/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.utils;

import com.mojang.authlib.GameProfile;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.entity.EntityHuman;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.UsernameUtils;
import ganymedes01.headcrumbs.utils.Utils;
import ganymedes01.headcrumbs.utils.helpers.HeadDropHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;

public class HeadUtils {
    private static final String OWNER_TAG = "SkullOwner";
    public static final List<ItemStack> players = new LinkedList<ItemStack>();

    public static void loadPlayerHeads() {
        Random rand = new Random();
        List<String> allNames = Headcrumbs.getAllNames();
        Collections.sort(allNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        for (String name : allNames) {
            if ((name = name.trim()) == null || name.isEmpty()) continue;
            ItemStack head = HeadUtils.createHeadFor(name);
            if (Headcrumbs.addPlayerHeadsAsDungeonLoot) {
                rand.setSeed(name.hashCode());
                Utils.addDungeonLoot(head.func_77946_l(), 1, 1, 1 + rand.nextInt(Headcrumbs.headsDungeonLootMaxWeight));
                Utils.addStrongholdLoot(head.func_77946_l(), 1, 1, 2 + rand.nextInt(Math.max(1, Headcrumbs.headsDungeonLootMaxWeight - 1)));
            }
            players.add(head);
        }
    }

    public static ItemStack getHeadfromEntity(EntityLivingBase target) {
        if (target.func_70631_g_()) {
            return null;
        }
        if (target instanceof EntityHuman) {
            return HeadUtils.createHeadFor(((EntityHuman)target).getUsername());
        }
        if (target instanceof EntityPlayer) {
            return HeadUtils.createHeadFor((EntityPlayer)target);
        }
        ItemStack head = HeadDropHelper.getHead((Entity)target);
        if (head != null) {
            return head;
        }
        return null;
    }

    public static ItemStack createHeadFor(String username) {
        return HeadUtils.createHeadFor(new GameProfile(null, UsernameUtils.getFixedUsername(username)));
    }

    public static ItemStack createHeadFor(EntityPlayer player) {
        return HeadUtils.createHeadFor(player.func_146103_bH());
    }

    public static ItemStack createHeadFor(GameProfile profile) {
        ItemStack stack = SkullTypes.player.getStack();
        stack.func_77982_d(new NBTTagCompound());
        NBTTagCompound profileData = new NBTTagCompound();
        NBTUtil.func_152460_a((NBTTagCompound)profileData, (GameProfile)profile);
        stack.func_77978_p().func_74782_a(OWNER_TAG, (NBTBase)profileData);
        return stack;
    }

    public static GameProfile getGameProfile(ItemStack stack) {
        GameProfile profile = null;
        try {
            if (stack.func_77942_o()) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt.func_150297_b(OWNER_TAG, 10)) {
                    profile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l(OWNER_TAG));
                } else if (nbt.func_150297_b(OWNER_TAG, 8)) {
                    profile = new GameProfile(null, nbt.func_74779_i(OWNER_TAG));
                } else if (nbt.func_150297_b("OwnerUUID", 8)) {
                    profile = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(UUID.fromString(nbt.func_74779_i("OwnerUUID")));
                    profile = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(profile, true);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return profile;
    }

    public static String getName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_150297_b(OWNER_TAG, 10)) {
                GameProfile profile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l(OWNER_TAG));
                if (profile != null) {
                    return profile.getName();
                }
            } else if (nbt.func_150297_b(OWNER_TAG, 8)) {
                return nbt.func_74779_i(OWNER_TAG);
            }
        }
        return null;
    }
}

