/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.eventHandlers;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.entity.EntityHuman;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.HeadUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class HandlerEvents {
    private static List<String> hardcodedBlacklist = Arrays.asList("Twilight Forest", "Erebus", "The Outer Lands");
    private static Item cleaver;

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        String name;
        if (event.entityLiving instanceof EntityHuman && (hardcodedBlacklist.contains(name = event.world.field_73011_w.func_80007_l()) || HandlerEvents.isDimensionBlackListed(event.world.field_73011_w.field_76574_g))) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static boolean isDimensionBlackListed(int dimensionId) {
        for (int id : Headcrumbs.blacklistedDimensions) {
            if (dimensionId != id) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDrop(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70170_p.func_82736_K().func_82766_b("keepInventory") && entity instanceof EntityPlayerMP) {
            ArrayList<EntityItem> drops = new ArrayList<EntityItem>();
            ItemStack weapon = this.getWeapon(event.source);
            int looting = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)weapon);
            this.drop(event.entityLiving, event.source, looting, drops);
            if (!drops.isEmpty()) {
                for (EntityItem item : drops) {
                    ((EntityPlayerMP)entity).func_71012_a(item);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        this.drop(event.entityLiving, event.source, event.lootingLevel, event.drops);
    }

    private void drop(EntityLivingBase entity, DamageSource source, int looting, List<EntityItem> drops) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_110143_aJ() > 0.0f) {
            return;
        }
        boolean isPoweredCreeper = Headcrumbs.enableChargedCreeperKills && this.isPoweredCreeper(source);
        int beheading = this.getBeaheadingLevel(this.getWeapon(source));
        if (isPoweredCreeper || this.shouldDoRandomDrop(entity.field_70170_p.field_73012_v, beheading, looting)) {
            ItemStack stack = HeadUtils.getHeadfromEntity(entity);
            if (stack == null) {
                return;
            }
            if (beheading > 0 && stack.func_77973_b() == Items.field_151144_bL) {
                return;
            }
            if ((stack.func_77973_b() != Items.field_151144_bL || Headcrumbs.enableVanillaHeadsDrop) && (this.isPlayerHead(stack) || Headcrumbs.enableMobsAndAnimalHeads)) {
                this.addDrop(stack, entity, drops);
            }
        }
    }

    private boolean isPoweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) != null && entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n();
        }
        return false;
    }

    private boolean isPlayerHead(ItemStack stack) {
        return stack.func_77973_b() == ModItems.skull && stack.func_77960_j() == SkullTypes.player.ordinal();
    }

    private boolean shouldDoRandomDrop(Random rand, int beheading, int looting) {
        if (beheading > 0) {
            return rand.nextInt(100) < beheading * 10;
        }
        int chance = Math.max(1, Headcrumbs.headDropChance / Math.max(looting + 1, 1));
        return Headcrumbs.enableRandomHeadDrop && rand.nextInt(chance) == 0;
    }

    private int getBeaheadingLevel(ItemStack weapon) {
        if (Headcrumbs.isTinkersConstructLoaded) {
            NBTTagCompound infiTool;
            if (cleaver == null) {
                try {
                    Class<?> TinkerTools = Class.forName("tconstruct.tools.TinkerTools");
                    Field field = TinkerTools.getDeclaredField("cleaver");
                    field.setAccessible(true);
                    cleaver = (Item)field.get(null);
                }
                catch (Exception TinkerTools) {
                    // empty catch block
                }
            }
            if (weapon == null || !weapon.func_77942_o()) {
                return 0;
            }
            if (weapon.func_77978_p().func_150297_b("InfiTool", 10) && (infiTool = weapon.func_77978_p().func_74775_l("InfiTool")).func_150297_b("Beheading", 3)) {
                int beheading = infiTool.func_74762_e("Beheading");
                if (cleaver == weapon.func_77973_b()) {
                    beheading += 2;
                }
                return beheading;
            }
        }
        return 0;
    }

    private ItemStack getWeapon(DamageSource source) {
        Entity entity;
        if (source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_71045_bC();
        }
        return null;
    }

    private void addDrop(ItemStack stack, EntityLivingBase entity, List<EntityItem> drops) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        ArrayList<EntityItem> toRemove = new ArrayList<EntityItem>();
        for (EntityItem drop : drops) {
            ItemStack dropStack = drop.func_92059_d();
            if (dropStack.func_77973_b() != Items.field_151144_bL || dropStack.func_77960_j() == 1) continue;
            toRemove.add(drop);
        }
        drops.removeAll(toRemove);
        EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        entityItem.field_145804_b = 10;
        drops.add(entityItem);
    }
}

