/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.ModBlocks;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.command.HeadcrumbsCommand;
import ganymedes01.headcrumbs.configs.ConfigHandler;
import ganymedes01.headcrumbs.entity.EntityHuman;
import ganymedes01.headcrumbs.entity.VIPHandler;
import ganymedes01.headcrumbs.items.HumanEgg;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.network.PacketHandler;
import ganymedes01.headcrumbs.proxy.CommonProxy;
import ganymedes01.headcrumbs.recipe.PlayerSkullRecipe;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.UsercacheChecker;
import ganymedes01.headcrumbs.utils.UsernameUtils;
import ganymedes01.headcrumbs.utils.helpers.ElementalCreepersHelper;
import ganymedes01.headcrumbs.utils.helpers.EnderZooHelper;
import ganymedes01.headcrumbs.utils.helpers.EtFuturumHelper;
import ganymedes01.headcrumbs.utils.helpers.GrimoireOfGaiaHelper;
import ganymedes01.headcrumbs.utils.helpers.HeadDropHelper;
import ganymedes01.headcrumbs.utils.helpers.LaserCreepersHelper;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelper;
import ganymedes01.headcrumbs.utils.helpers.NaturaHelper;
import ganymedes01.headcrumbs.utils.helpers.PrimitiveMobsHelper;
import ganymedes01.headcrumbs.utils.helpers.TEHelper;
import ganymedes01.headcrumbs.utils.helpers.ThaumcraftHelper;
import ganymedes01.headcrumbs.utils.helpers.TwilightForestHelper;
import ganymedes01.headcrumbs.utils.helpers.VanillaHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="headcrumbs", name="Headcrumbs", version="1.7.4", dependencies="required-after:Forge@[10.13.4.1558,);", guiFactory="ganymedes01.headcrumbs.configs.ConfigGuiFactory")
public class Headcrumbs {
    @Mod.Instance(value="headcrumbs")
    public static Headcrumbs instance;
    @SidedProxy(clientSide="ganymedes01.headcrumbs.proxy.ClientProxy", serverSide="ganymedes01.headcrumbs.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tab;
    public static String[] others;
    public static String[] modders;
    public static String[] youtubers;
    public static String[] mojang;
    public static String[] mindCrack;
    public static String[] hermitcraft;
    public static String[] forgeCraft;
    public static String[] ftb;
    public static String[] technic;
    public static boolean enableModSent;
    public static List<String> modsent;
    public static boolean enableVanillaHeadsDrop;
    public static boolean enableRandomHeadDrop;
    public static int headDropChance;
    public static boolean addPlayerHeadsAsDungeonLoot;
    public static boolean enableMobsAndAnimalHeads;
    public static int headsDungeonLootMaxWeight;
    public static boolean hidePlayerHeadsFromTab;
    public static boolean enableChargedCreeperKills;
    public static boolean enablePlayerStatues;
    public static boolean enableTooltips;
    public static boolean enableHeadConversion;
    public static boolean enableHumanMobs;
    public static boolean humansOpenDoors;
    public static int celebrityProb;
    public static int celebrityMin;
    public static int celebrityMax;
    public static double babyHumanChance;
    public static boolean enableVIPs;
    public static boolean enableBaarbra;
    public static int[] blacklistedDimensions;
    public static String humanNamePrefix;
    public static boolean use18PlayerModel;
    public static boolean humansAttackTwins;
    public static boolean isTinkersConstructLoaded;
    public static Item spawnEgg;
    public static Block clay;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.init(event.getSuggestedConfigurationFile());
        ModBlocks.init();
        ModItems.init();
        UsernameUtils.initMap();
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack(ModItems.skull, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE));
        for (SkullTypes type : SkullTypes.values()) {
            OreDictionary.registerOre((String)("skull" + type.name().substring(0, 1).toUpperCase() + type.name().substring(1)), (ItemStack)new ItemStack(ModItems.skull, 1, type.ordinal()));
        }
        OreDictionary.registerOre((String)"skullSkeleton", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 0));
        OreDictionary.registerOre((String)"skullWitherSkeleton", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 1));
        OreDictionary.registerOre((String)"skullZombie", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 2));
        OreDictionary.registerOre((String)"skullPlayer", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 3));
        OreDictionary.registerOre((String)"skullCreeper", (ItemStack)new ItemStack(Items.field_151144_bL, 1, 4));
        if (enableHeadConversion) {
            RecipeSorter.register((String)"headcrumbs.playerskullrecipe", PlayerSkullRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)new PlayerSkullRecipe(SkullTypes.player.getStack(), new ItemStack(Items.field_151144_bL, 1, 3)));
            GameRegistry.addRecipe((IRecipe)new PlayerSkullRecipe(new ItemStack(Items.field_151144_bL, 1, 3), SkullTypes.player.getStack()));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        proxy.registerEvents();
        proxy.registerTileEntities();
        proxy.registerRenderers();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"ganymedes01.headcrumbs.waila.WailaRegistrar.wailaCallback");
        if (enableHumanMobs) {
            EntityList.field_75625_b.put("Celebrity", EntityHuman.class);
            EntityRegistry.registerModEntity(EntityHuman.class, (String)"Human", (int)0, (Object)instance, (int)512, (int)1, (boolean)true);
            spawnEgg = new HumanEgg();
            GameRegistry.registerItem((Item)spawnEgg, (String)"egg");
            OreDictionary.registerOre((String)"mobEgg", (Item)spawnEgg);
            VIPHandler.init();
        }
        isTinkersConstructLoaded = Loader.isModLoaded((String)"TConstruct");
        if (Loader.isModLoaded((String)"ganysend")) {
            this.addEnderFurnaceRecipe(new ItemStack(Blocks.field_150380_bt), "skullEnderDragon");
            this.addEnderFurnaceRecipe(new ItemStack(Items.field_151156_bN), "skullWither");
        }
    }

    private void addEnderFurnaceRecipe(ItemStack output, Object ... input) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound out = new NBTTagCompound();
        output.func_77955_b(out);
        nbt.func_74782_a("output", (NBTBase)out);
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            if (input[i] instanceof ItemStack) {
                NBTTagCompound in = new NBTTagCompound();
                ((ItemStack)input[i]).func_77955_b(in);
                nbt.func_74782_a("input" + i, (NBTBase)in);
                continue;
            }
            nbt.func_74778_a("input" + i, (String)input[i]);
        }
        FMLInterModComms.sendMessage((String)"ganysend", (String)"enderFurnaceRecipe", (NBTTagCompound)nbt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        HeadUtils.loadPlayerHeads();
        HeadDropHelper.register(new EtFuturumHelper());
        HeadDropHelper.register(new LaserCreepersHelper());
        HeadDropHelper.register(new TwilightForestHelper());
        HeadDropHelper.register(new TEHelper());
        HeadDropHelper.register(new NaturaHelper());
        HeadDropHelper.register(new ThaumcraftHelper());
        HeadDropHelper.register(new LycanitesHelper());
        HeadDropHelper.register(new EnderZooHelper());
        HeadDropHelper.register(new PrimitiveMobsHelper());
        HeadDropHelper.register(new GrimoireOfGaiaHelper());
        HeadDropHelper.register(new ElementalCreepersHelper());
        HeadDropHelper.register(new VanillaHelper());
        UsercacheChecker.check();
        if (enableHumanMobs) {
            Headcrumbs.addHumanSpawns();
        }
        if (enableHeadConversion && Loader.isModLoaded((String)"TwilightForest")) {
            Item tropy = (Item)Item.field_150901_e.func_82594_a("TwilightForest:item.trophy");
            this.addConvertionRecipe(SkullTypes.hydra.getStack(), new ItemStack(tropy, 1, 0));
            this.addConvertionRecipe(SkullTypes.nagaTF.getStack(), new ItemStack(tropy, 1, 1));
            this.addConvertionRecipe(SkullTypes.lich.getStack(), new ItemStack(tropy, 1, 2));
            this.addConvertionRecipe(SkullTypes.urGhast.getStack(), new ItemStack(tropy, 1, 3));
            this.addConvertionRecipe(SkullTypes.snowQueen.getStack(), new ItemStack(tropy, 1, 4));
        }
    }

    private void addConvertionRecipe(ItemStack output, ItemStack input) {
        GameRegistry.addShapelessRecipe((ItemStack)output, (Object[])new Object[]{input});
        GameRegistry.addShapelessRecipe((ItemStack)input, (Object[])new Object[]{output});
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new HeadcrumbsCommand());
    }

    @Mod.EventHandler
    public void imcEvent(FMLInterModComms.IMCEvent event) {
        Logger logger = LogManager.getLogger((String)"headcrumbs");
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equals("add-username")) {
                if (!enableModSent) {
                    logger.info(String.format("%s tried to add %s to the username list, but the feature has been disabled by the user.", message.getSender(), message.getStringValue()));
                    continue;
                }
                if (message.isStringMessage()) {
                    String username = message.getStringValue();
                    if (!Headcrumbs.getAllNames().contains(username)) {
                        modsent.add(username);
                        logger.info(String.format("%s added %s to the username list", message.getSender(), message.getStringValue()));
                        continue;
                    }
                    logger.info(String.format("%s tried to add %s to the username list, but it was already present", message.getSender(), message.getStringValue()));
                    continue;
                }
                logger.error(String.format("Invalid message type sent from %s", message.getSender()));
                continue;
            }
            logger.error(String.format("Invalid message key sent from %s: %s", message.getSender(), message.key));
        }
    }

    public static List<String> getAllNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(others));
        names.addAll(Arrays.asList(modders));
        names.addAll(Arrays.asList(youtubers));
        names.addAll(Arrays.asList(mojang));
        names.addAll(Arrays.asList(mindCrack));
        names.addAll(Arrays.asList(hermitcraft));
        names.addAll(Arrays.asList(forgeCraft));
        names.addAll(Arrays.asList(ftb));
        names.addAll(Arrays.asList(technic));
        if (enableModSent) {
            names.addAll(modsent);
        }
        return new ArrayList<String>(names);
    }

    private static void addHumanSpawns() {
        List<BiomeDictionary.Type> blacklistedBiomes = Arrays.asList(BiomeDictionary.Type.MUSHROOM);
        List<String> blacklistedBiomeNames = Arrays.asList("Tainted Land");
        LinkedList<BiomeGenBase> biomes = new LinkedList<BiomeGenBase>();
        block2: for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || blacklistedBiomeNames.contains(biome.field_76791_y)) continue;
            for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                if (blacklistedBiomes.contains(type)) continue block2;
            }
            for (Object obj : biome.func_76747_a(EnumCreatureType.monster)) {
                if (!(obj instanceof BiomeGenBase.SpawnListEntry)) continue;
                BiomeGenBase.SpawnListEntry entry = (BiomeGenBase.SpawnListEntry)obj;
                try {
                    boolean isSpecialMobsZombie;
                    boolean bl = isSpecialMobsZombie = Loader.isModLoaded((String)"SpecialMobs") && Class.forName("toast.specialMobs.entity.zombie.Entity_SpecialZombie").isAssignableFrom(entry.field_76300_b);
                    if (entry.field_76300_b != EntityZombie.class && !isSpecialMobsZombie) continue;
                    biomes.add(biome);
                    continue block2;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        EntityRegistry.addSpawn(EntityHuman.class, (int)celebrityProb, (int)celebrityMin, (int)celebrityMax, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes.toArray(new BiomeGenBase[biomes.size()]));
    }

    static {
        tab = new CreativeTabs("headcrumbs"){
            @SideOnly(value=Side.CLIENT)
            private ItemStack displayStack;

            public Item func_78016_d() {
                return ModItems.skull;
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_151244_d() {
                if (this.displayStack == null) {
                    Random rand = new Random();
                    ArrayList<SkullTypes> types = new ArrayList<SkullTypes>();
                    for (SkullTypes type : SkullTypes.values()) {
                        if (!type.canShow() || type == SkullTypes.lycanites || type == SkullTypes.player) continue;
                        types.add(type);
                    }
                    this.displayStack = types.isEmpty() ? new ItemStack(Items.field_151144_bL) : ((SkullTypes)((Object)types.get(rand.nextInt(types.size())))).getStack();
                }
                return this.displayStack;
            }
        };
        others = new String[]{"ez", "saukawolf", "Fullapple1991", "Kaisacles", "Cindric", "wiiv", "deadmau5", "muted79", "DrummingFish", "Kyrinon", "vasili02", "Jeb_Jeb", "KingPurpleRaptor", "DylanGK", "sadris", "Herobrine", "kehaan"};
        modders = new String[]{"sinkillerj", "Silentine", "techbrew", "Drullkus", "aidancbrady", "Melonar", "Cricket", "YorkAARGH", "spacetoad", "FyberOptic", "Vexatos", "Mineshopper", "AUTOMATIC_MAIDEN", "sanandreasMC", "FatherToast", "Erasmus_Crowley", "Alblaka", "Emoniph", "Nuchaz", "Kobata", "powercrystals", "AbrarSyed", "sdkillen", "Taelnia", "Lycanite", "asiekierka", "GregoriusT", "skyboy", "Flaxbeard", "Emasher", "joshiejack", "Reika", "ganymedes01", "Pokefenn", "chylex", "vadis365", "jakimfett", "Lunatrius", "copygirl", "amadornes", "DrZhark", "KeldonSlayer", "KarelMikie3", "Mfernflower", "LuckyLucyF", "Tristaric", "fry_"};
        youtubers = new String[]{"wyld", "SkythekidRS", "Bashur", "Straymaverick", "SOTMead", "Nerdcubed", "Kleetho", "DanTDM", "ashzification", "Runew0lf", "GiantWaffle", "Bacon_Donut", "Heph", "ChimneySwift", "FuriousDestroyer", "paulsoaresjr", "SuperGirlyGamer", "CyaNideEPiC", "Jarrenitis", "direwolf20", "Sjin", "Xephos", "LividCoffee", "pewdie", "Rythian", "Zoeya", "TheStrippin", "InTheLittleWood", "Quetzz", "Blorph", "xbony2", "generikb", "GameChap", "CaptainSparklez", "AntVenom", "CavemanFilms", "Fosler", "BevoLJ", "Sips_", "Honeydew", "thejims", "BertieChap", "TobyofBuscus", "corjaantje", "RealThinknoodles", "ZexyZek", "WesWilson", "BdoubleO100", "tedyhere", "riskable"};
        mojang = new String[]{"Notch", "jeb_", "C418", "Dinnerbone", "Grumm", "Searge", "EvilSeph", "Marc_IRL", "FruktHamster", "ProfMobius", "carlmanneh", "vubui", "_tommo_", "kappe", "geuder", "mollstam", "xlson", "KrisJelbring", "amir343", "NeonMaster", "carnalizer", "eldrone", "MinecraftChick", "Bopogamel", "Hideous", "MidnightEnforcer"};
        mindCrack = new String[]{"adlingtont", "AnderZEL", "Arkas", "Aureylian", "AvidyaZEN", "BlameTC", "Coestar", "Docm77", "Guude", "JSano19", "kurtmac", "SuperMCGamer", "Mhykol", "Millbee", "Nebris", "OMGchad", "Pakratt0013", "PauseUnpause", "Pyro_0", "SethBling", "Sevadus", "Vechs_", "VintageBeef", "W92Baj", "Zisteau"};
        hermitcraft = new String[]{"Biffa2001", "falsesymmetry", "hypnotizd", "iJevin", "impulseSV", "Jessassin", "joehillssays", "Keralis1", "KingDaddyDMAC", "monkeyfarm", "Mumbo", "Pungence", "skyzm", "sl1pg8r", "Tango", "Tinfoilchef", "topmass", "xBCrafted", "Xisuma", "ZombieCleo", "zueljin", "Etho"};
        forgeCraft = new String[]{"Imalune", "ShadwDrgn", "Cojomax99", "Freyjadono", "Vaht", "EcuTruin", "boni", "glasspelican", "Mr_okushama", "AlgorithmX2", "Mikeemoo", "_CrazyP_", "MysteriousAges", "MineMaarten", "nekosune", "Mr_Damien_Hazard", "tlovetech", "FireBall1725", "PurpleMentat", "Calclavia", "Minalien", "fuj1n", "Mithion", "RWTema", "alexbegt", "WayofFlowingTime", "TTFTCUTS", "bspkrs", "amnet", "azanor", "chicken_bones", "Cloudhunter", "RazzleberryFox", "CovertJaguar", "cpw11", "dan200", "Eloraam", "florastar", "iChun", "KingLemming", "Krapht", "peterixxx", "Adubbz", "LexManos", "TheMattaBase", "mDiyo", "Myrathi", "Morvelaira", "Pahimar", "sfPlayer1", "Arkember", "Rorax", "Sacheverell", "sirsengir", "Soaryn", "x3n0ph0b3", "XCompWiz", "Vswe", "Vazkii", "ZeldoKavira", "AtomicBlom", "neptunepink", "EddieRuckus", "LordDusk", "Kihira", "Vaygrim", "Kaelten", "MatrexsVigil", "tfox83", "jadedcat", "mezz", "aivu", "ArashiDragon", "Binnie567", "c4ts", "Clairetic", "consolegrl", "Corosus", "electronicbird", "faunastar", "Forstride", "IceBladeRage", "Minakun", "odedex", "OvermindDL1", "RichardG867", "ted80", "Benimatic"};
        ftb = new String[]{"eyamaz", "slowpoke101", "progwml6", "Captainnana", "Gideonseymour", "Watchful11", "SnowShock35"};
        technic = new String[]{"GenPage", "Slink730", "sct", "KakerMix", "Skuli_Steinulf", "Talonos"};
        enableModSent = true;
        modsent = new ArrayList<String>();
        enableVanillaHeadsDrop = true;
        enableRandomHeadDrop = true;
        headDropChance = 200;
        addPlayerHeadsAsDungeonLoot = true;
        enableMobsAndAnimalHeads = true;
        headsDungeonLootMaxWeight = 1;
        hidePlayerHeadsFromTab = false;
        enableChargedCreeperKills = true;
        enablePlayerStatues = true;
        enableTooltips = true;
        enableHeadConversion = true;
        enableHumanMobs = true;
        humansOpenDoors = true;
        celebrityProb = 80;
        celebrityMin = 4;
        celebrityMax = 4;
        babyHumanChance = 0.1;
        enableVIPs = true;
        enableBaarbra = true;
        blacklistedDimensions = new int[]{1, -1};
        humanNamePrefix = "";
        use18PlayerModel = false;
        humansAttackTwins = true;
        isTinkersConstructLoaded = false;
    }
}

