/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.client.objects;

import com.black_dog20.servertabinfo.client.CustomPlayerList;
import com.black_dog20.servertabinfo.client.GuiTabPage;
import com.black_dog20.servertabinfo.client.objects.IRenderable;
import com.black_dog20.servertabinfo.utility.CompatibilityHelper;
import com.black_dog20.servertabinfo.utility.RenderHelper;
import com.black_dog20.servertabinfo.utility.TpsDimension;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.resources.I18n;

public class Player
implements IRenderable {
    private GuiPlayerInfo networkInfo;
    private Minecraft mc;
    private int spacing = 2;

    public Player(GuiPlayerInfo info, Minecraft minecraft) {
        this.networkInfo = info;
        this.mc = minecraft;
    }

    @Override
    public int getWidth() {
        int width = 0;
        ArrayList<String> playerList = new ArrayList<String>();
        for (IRenderable p : CustomPlayerList.playerList) {
            if (!(p instanceof Player)) continue;
            playerList.add(((Player)p).getPlayerName());
        }
        width += RenderHelper.findMaxWidthString(playerList, this.mc);
        width += 2 * this.spacing;
        width = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? (width += CompatibilityHelper.getStringWidth(this.mc, "Analysing")) : (GuiTabPage.responseVersion < 3 ? (width += CompatibilityHelper.getStringWidth(this.mc, "Unknown")) : (width += CompatibilityHelper.getStringWidth(this.mc, this.getDim(Player.getPlayerName(this.networkInfo)))));
        width += this.spacing;
        return width += CompatibilityHelper.getStringWidth(this.mc, this.getPing());
    }

    @Override
    public int getWidthOfElement(int n) {
        return this.getWidthArrayPrivate()[n];
    }

    @Override
    public int[] getWidthArray() {
        return this.getWidtArrayHelper(false);
    }

    private int[] getWidthArrayPrivate() {
        return this.getWidtArrayHelper(true);
    }

    private int[] getWidtArrayHelper(boolean here) {
        int[] width = new int[3];
        int tempWidth = 0;
        if (!here) {
            ArrayList<String> playerList = new ArrayList<String>();
            for (IRenderable p : CustomPlayerList.playerList) {
                if (!(p instanceof Player)) continue;
                playerList.add(((Player)p).getPlayerName());
            }
            tempWidth += RenderHelper.findMaxWidthString(playerList, this.mc);
        } else {
            tempWidth += CompatibilityHelper.getStringWidth(this.mc, this.getPlayerName());
        }
        width[0] = tempWidth += 2 * this.spacing;
        tempWidth = 0;
        tempWidth = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? (tempWidth += CompatibilityHelper.getStringWidth(this.mc, I18n.func_135052_a((String)"gui.servertabinfo.analysing", (Object[])new Object[0]))) : (GuiTabPage.responseVersion < 3 ? (tempWidth += CompatibilityHelper.getStringWidth(this.mc, I18n.func_135052_a((String)"gui.servertabinfo.unknown", (Object[])new Object[0]))) : (tempWidth += CompatibilityHelper.getStringWidth(this.mc, this.getDim(this.getPlayerName()))));
        width[1] = tempWidth += this.spacing;
        tempWidth = 0;
        width[2] = tempWidth += CompatibilityHelper.getStringWidth(this.mc, this.getPing());
        return width;
    }

    @Override
    public void render(int x, int y, int width) {
        int leftoverspacing = width - this.getWidth();
        String s4 = this.getPlayerName();
        CompatibilityHelper.drawStringWithShadow(this.mc, s4, x, y, -1);
        String dim = "Unknown";
        dim = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? "Analysing" : (GuiTabPage.responseVersion < 3 ? "Unknown" : this.getDim(this.getPlayerName()));
        CompatibilityHelper.drawStringWithShadow(this.mc, dim, x += CompatibilityHelper.getStringWidth(this.mc, s4) + 2 * this.spacing + leftoverspacing, y, -1);
        CompatibilityHelper.drawStringWithShadow(this.mc, this.getPing(), x += CompatibilityHelper.getStringWidth(this.mc, dim) + this.spacing, y, -1);
    }

    private int calcLeftOverspace(int[] maxWidth, int n) {
        return maxWidth[n] - this.getWidthOfElement(n);
    }

    @Override
    public void render(int x, int y, int[] maxWidth) {
        String s4 = this.getPlayerName();
        CompatibilityHelper.drawStringWithShadow(this.mc, s4, x, y, -1);
        String dim = "Unknown";
        dim = GuiTabPage.responseVersion >= 3 && CustomPlayerList.playerDims.isEmpty() ? "Analysing" : (GuiTabPage.responseVersion < 3 ? "Unknown" : this.getDim(this.getPlayerName()));
        CompatibilityHelper.drawStringWithShadow(this.mc, dim, x += CompatibilityHelper.getStringWidth(this.mc, s4) + 2 * this.spacing + this.calcLeftOverspace(maxWidth, 0), y, -1);
        CompatibilityHelper.drawStringWithShadow(this.mc, this.getPing(), x += CompatibilityHelper.getStringWidth(this.mc, dim) + this.spacing + this.calcLeftOverspace(maxWidth, 1), y, -1);
    }

    public String getPlayerName() {
        return this.networkInfo.field_78831_a;
    }

    public static String getPlayerName(GuiPlayerInfo networkPlayerInfoIn) {
        return networkPlayerInfoIn.field_78831_a;
    }

    private String getPing() {
        String pingValue = CompatibilityHelper.text(Integer.toString(this.networkInfo.field_78829_b));
        String ms = CompatibilityHelper.translate("gui.servertabinfo.ms");
        String pingString = String.format("%s%s", pingValue, ms);
        return pingString;
    }

    private String getDim(String player) {
        TpsDimension dim = CustomPlayerList.playerDims.get(player);
        if (dim != null) {
            return CustomPlayerList.playerDims.get(player).getShortDimString(2);
        }
        return "";
    }
}

