/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.client;

import com.black_dog20.servertabinfo.ServerTabInfo;
import com.black_dog20.servertabinfo.client.GuiTabPage;
import com.black_dog20.servertabinfo.client.objects.IRenderable;
import com.black_dog20.servertabinfo.config.ModConfig;
import com.black_dog20.servertabinfo.utility.CompatibilityHelper;
import com.black_dog20.servertabinfo.utility.RenderHelper;
import com.black_dog20.servertabinfo.utility.TpsDimension;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class TpsPage {
    private Minecraft mc;
    private int maxPages = 1;
    private int currentPage = 1;
    private int ticks = 0;
    private int changeTicks = 200;

    public TpsPage(Minecraft mc) {
        this.mc = mc;
    }

    public boolean render() {
        int startTop = 10;
        this.renderClientServerVersion();
        startTop = this.renderPing(startTop);
        this.renderTps(startTop);
        return true;
    }

    private int renderTps(int startTop) {
        ++this.ticks;
        int hith = (int)((double)(GuiTabPage.hight - startTop) - (double)GuiTabPage.hight * 0.15);
        int itemPerPage = (int)Math.floor(hith / this.mc.field_71466_p.field_78288_b / 2);
        ArrayList<IRenderable> Tlist = new ArrayList<IRenderable>();
        if (GuiTabPage.dims == null || GuiTabPage.dims.isEmpty()) {
            return startTop;
        }
        for (TpsDimension tpsInfo : GuiTabPage.dims) {
            Tlist.add(new TpsDimension(tpsInfo.name, tpsInfo.meanTickTime, tpsInfo.Id, GuiTabPage.responseVersion));
        }
        this.maxPages = (int)Math.ceil((double)Tlist.size() / (double)itemPerPage);
        if (this.ticks % this.changeTicks == 0) {
            this.ticks = 0;
            this.changePage();
        }
        List<IRenderable> dimsT = RenderHelper.getPage(this.currentPage, itemPerPage, Tlist);
        int y = RenderHelper.RenderObjectList(dimsT, this.mc, startTop, GuiTabPage.width);
        String s = I18n.func_135052_a((String)"gui.servertabinfo.page", (Object[])new Object[0]) + " " + Integer.toString(this.currentPage) + " of " + Integer.toString(this.maxPages);
        int x = GuiTabPage.width / 2;
        CompatibilityHelper.drawStringWithShadow(this.mc, s, (float)x + 2.0f, y, -1);
        return y += this.mc.field_71466_p.field_78288_b;
    }

    private void changePage() {
        this.currentPage = this.currentPage == this.maxPages ? 1 : ++this.currentPage;
    }

    private int renderPing(int startTop) {
        if (ModConfig.ping && GuiTabPage.responseVersion >= 2 && !ServerTabInfo.Proxy.isSinglePlayer()) {
            String pingText = CompatibilityHelper.translate("gui.servertabinfo.ping");
            String pingValue = CompatibilityHelper.text(Integer.toString(GuiTabPage.ping));
            String ms = CompatibilityHelper.translate("gui.servertabinfo.ms");
            String pingString = String.format("%s: %s%s", pingText, pingValue, ms);
            ArrayList<String> input = new ArrayList<String>();
            input.add(pingString);
            startTop = RenderHelper.RenderList(input, this.mc, startTop, GuiTabPage.width);
            startTop += 10;
        }
        return startTop;
    }

    private void renderClientServerVersion() {
        if (ModConfig.version) {
            int startTopp = 1;
            String cv = "C: Final-b3";
            String sv = "S: " + (GuiTabPage.serverVersion != null ? GuiTabPage.serverVersion : "1.0.0");
            CompatibilityHelper.glPush();
            if (this.mc.field_71474_y.field_74335_Z != 1) {
                CompatibilityHelper.glScale(0.5);
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(cv);
            if (!ServerTabInfo.Proxy.isSinglePlayer()) {
                list.add(sv);
            }
            RenderHelper.RenderListAtStartPoint(list, this.mc, 0, startTopp);
            CompatibilityHelper.glPop();
        }
    }
}

