/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismBlocks;
import mekanism.common.SideData;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChemicalInjectionChamber
extends TileEntityAdvancedElectricMachine<InjectionRecipe> {
    public TileEntityChemicalInjectionChamber() {
        super("injection", "ChemicalInjectionChamber", MekanismConfig.usage.chemicalInjectionChamberUsage, 1, 200, BlockMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.baseEnergy);
        this.configComponent.addSupported(TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.fillConfig(TransmissionType.GAS, 1);
        this.configComponent.setCanEject(TransmissionType.GAS, false);
    }

    @Override
    public Map getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get();
    }

    @Override
    public GasStack getItemGas(ItemStack itemstack) {
        if (MekanismUtils.getOreDictName(itemstack).contains("dustSulfur")) {
            return new GasStack(GasRegistry.getGas("sulfuricAcid"), 2);
        }
        if (MekanismUtils.getOreDictName(itemstack).contains("dustSalt")) {
            return new GasStack(GasRegistry.getGas("hydrogenChloride"), 2);
        }
        if (Block.func_149634_a((Item)itemstack.func_77973_b()) == MekanismBlocks.GasTank && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && this.isValidGas(((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas())) {
            return new GasStack(GasRegistry.getGas("sulfuricAcid"), 1);
        }
        return null;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side.ordinal(), this.facing).hasSlot(0)) {
            return this.isValidGas(type);
        }
        return false;
    }

    @Override
    public void handleSecondaryFuel() {
        if (this.inventory[1] != null && this.gasTank.getNeeded() > 0 && this.inventory[1].func_77973_b() instanceof IGasItem) {
            GasStack gas = ((IGasItem)this.inventory[1].func_77973_b()).getGas(this.inventory[1]);
            if (gas != null && this.isValidGas(gas.getGas())) {
                GasStack removed = GasTransmission.removeGas(this.inventory[1], this.gasTank.getGasType(), this.gasTank.getNeeded());
                this.gasTank.receive(removed, true);
            }
            return;
        }
        super.handleSecondaryFuel();
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return this.configComponent.getOutput(TransmissionType.GAS, side.ordinal(), this.facing).hasSlot(0);
    }

    @Override
    public boolean isValidGas(Gas gas) {
        return gas == GasRegistry.getGas("sulfuricAcid") || gas == GasRegistry.getGas("water") || gas == GasRegistry.getGas("hydrogenChloride");
    }

    @Override
    public boolean upgradeableSecondaryEfficiency() {
        return true;
    }

    @Override
    public boolean useStatisticalMechanics() {
        return true;
    }
}

