/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cpw.mods.fml.common.Optional;
import ic2.api.tile.IWrenchable;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IChunkLoadHandler;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.ITileNetwork;
import mekanism.common.block.BlockMachine;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

@Optional.Interface(iface="ic2.api.tile.IWrenchable", modid="IC2")
public abstract class TileEntityBasicBlock
extends TileEntity
implements IWrenchable,
ITileNetwork,
IChunkLoadHandler,
IFrequencyHandler {
    public int facing;
    public int clientFacing;
    public HashSet<EntityPlayer> playersUsing = new HashSet();
    public int ticker;
    public boolean redstone = false;
    public boolean redstoneLastTick = false;
    public boolean doAutoSync = true;
    public List<ITileComponent> components = new ArrayList<ITileComponent>();

    public void func_145845_h() {
        BlockMachine.MachineType type;
        if (!this.field_145850_b.field_72995_K && MekanismConfig.general.destroyDisabledBlocks && (type = BlockMachine.MachineType.get(this.func_145838_q(), this.func_145832_p())) != null && !type.isEnabled()) {
            Mekanism.logger.info("[Mekanism] Destroying machine of type '" + type.name + "' at coords " + Coord4D.get(this) + " as according to config.");
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
        for (ITileComponent component : this.components) {
            component.tick();
        }
        this.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.doAutoSync && this.playersUsing.size() > 0) {
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), (EntityPlayerMP)player);
            }
        }
        ++this.ticker;
        this.redstoneLastTick = this.redstone;
    }

    @Override
    public void onChunkLoad() {
        this.func_70296_d();
    }

    public void open(EntityPlayer player) {
        this.playersUsing.add(player);
    }

    public void close(EntityPlayer player) {
        this.playersUsing.remove(player);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            this.facing = dataStream.readInt();
            this.redstone = dataStream.readBoolean();
            if (this.clientFacing != this.facing) {
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.clientFacing = this.facing;
            }
            for (ITileComponent component : this.components) {
                component.read(dataStream);
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.facing);
        data.add(this.redstone);
        for (ITileComponent component : this.components) {
            component.write(data);
        }
        return data;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (ITileComponent component : this.components) {
            component.invalidate();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(this)));
        }
    }

    public abstract void onUpdate();

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.facing = nbtTags.func_74762_e("facing");
        this.redstone = nbtTags.func_74767_n("redstone");
        for (ITileComponent component : this.components) {
            component.read(nbtTags);
        }
    }

    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("facing", this.facing);
        nbtTags.func_74757_a("redstone", this.redstone);
        for (ITileComponent component : this.components) {
            component.write(nbtTags);
        }
    }

    @Optional.Method(modid="IC2")
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public short getFacing() {
        return (short)this.facing;
    }

    public void setFacing(short direction) {
        if (this.canSetFacing(direction)) {
            this.facing = direction;
        }
        if (this.facing != this.clientFacing && !this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.func_70296_d();
            this.clientFacing = this.facing;
        }
    }

    public boolean canSetFacing(int facing) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Optional.Method(modid="IC2")
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.func_145838_q().getPickBlock(null, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityPlayer);
    }

    public boolean isPowered() {
        return this.redstone;
    }

    public boolean wasPowered() {
        return this.redstoneLastTick;
    }

    public void onPowerChange() {
    }

    public void onNeighborChange(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.updatePower();
        }
    }

    private void updatePower() {
        boolean power = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.redstone != power) {
            this.redstone = power;
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.onPowerChange();
        }
    }

    public void onAdded() {
        this.updatePower();
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies && this instanceof ISecurityTile) {
            return ((ISecurityTile)((Object)this)).getSecurity().getFrequency();
        }
        return null;
    }
}

