/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class PacketSecurityMode
implements IMessageHandler<SecurityModeMessage, IMessage> {
    public IMessage onMessage(SecurityModeMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == SecurityPacketType.BLOCK) {
            String owner;
            TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
            if (tileEntity instanceof ISecurityTile && (owner = ((ISecurityTile)tileEntity).getSecurity().getOwner()) != null && player.func_70005_c_().equals(owner)) {
                ((ISecurityTile)tileEntity).getSecurity().setMode(message.value);
            }
        } else {
            ItemStack stack = player.func_71045_bC();
            if (stack.func_77973_b() instanceof ISecurityItem) {
                ((ISecurityItem)stack.func_77973_b()).setSecurity(stack, message.value);
            }
        }
        return null;
    }

    public static enum SecurityPacketType {
        BLOCK,
        ITEM;

    }

    public static class SecurityModeMessage
    implements IMessage {
        public SecurityPacketType packetType;
        public Coord4D coord4D;
        public ISecurityTile.SecurityMode value;

        public SecurityModeMessage() {
        }

        public SecurityModeMessage(Coord4D coord, ISecurityTile.SecurityMode control) {
            this.packetType = SecurityPacketType.BLOCK;
            this.coord4D = coord;
            this.value = control;
        }

        public SecurityModeMessage(ISecurityTile.SecurityMode control) {
            this.packetType = SecurityPacketType.ITEM;
            this.value = control;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == SecurityPacketType.BLOCK) {
                dataStream.writeInt(this.coord4D.xCoord);
                dataStream.writeInt(this.coord4D.yCoord);
                dataStream.writeInt(this.coord4D.zCoord);
                dataStream.writeInt(this.coord4D.dimensionId);
            }
            dataStream.writeInt(this.value.ordinal());
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = SecurityPacketType.values()[dataStream.readInt()];
            if (this.packetType == SecurityPacketType.BLOCK) {
                this.coord4D = Coord4D.read(dataStream);
            }
            this.value = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
        }
    }
}

