/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.Upgrade;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.tile.TileEntityBasicBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class PacketRemoveUpgrade
implements IMessageHandler<RemoveUpgradeMessage, IMessage> {
    public IMessage onMessage(RemoveUpgradeMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
        if (tileEntity instanceof IUpgradeTile && tileEntity instanceof TileEntityBasicBlock) {
            IUpgradeTile upgradeTile = (IUpgradeTile)tileEntity;
            Upgrade upgrade = Upgrade.values()[message.upgradeType];
            if (upgradeTile.getComponent().getUpgrades(upgrade) > 0 && player.field_71071_by.func_70441_a(upgrade.getStack())) {
                upgradeTile.getComponent().removeUpgrade(upgrade);
            }
        }
        return null;
    }

    public static class RemoveUpgradeMessage
    implements IMessage {
        public Coord4D coord4D;
        public int upgradeType;

        public RemoveUpgradeMessage() {
        }

        public RemoveUpgradeMessage(Coord4D coord, int type) {
            this.coord4D = coord;
            this.upgradeType = type;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            dataStream.writeInt(this.upgradeType);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.upgradeType = dataStream.readInt();
        }
    }
}

