/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.idextender.asm.transformer;

import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import ru.fewizz.idextender.asm.AsmTransformException;
import ru.fewizz.idextender.asm.AsmUtil;
import ru.fewizz.idextender.asm.IClassNodeTransformer;
import ru.fewizz.idextender.asm.Name;

public class VanillaExtendedBlockStorage
implements IClassNodeTransformer {
    @Override
    public void transform(ClassNode cn) {
        cn.fields.add(new FieldNode(1, "block16BArray", "[S", null, null));
        AsmUtil.makePublic(AsmUtil.findField(cn, Name.ebs_blockRefCount));
        AsmUtil.makePublic(AsmUtil.findField(cn, Name.ebs_tickRefCount));
        MethodNode method = AsmUtil.findMethod(cn, "<init>");
        this.transformConstructor(cn, method);
        method = AsmUtil.findMethod(cn, Name.ebs_getBlock);
        this.transformGetBlock(cn, method);
        method = AsmUtil.findMethod(cn, Name.ebs_setBlock);
        this.transformSetBlock(cn, method);
        method = AsmUtil.findMethod(cn, Name.ebs_getBlockMSBArray);
        this.transformGetBlockMSBArray(cn, method);
        method = AsmUtil.findMethod(cn, Name.ebs_removeInvalidBlocks);
        this.transformRemoveInvalidBlocks(cn, method);
    }

    private void transformConstructor(ClassNode cn, MethodNode method) {
        AbstractInsnNode insn;
        InsnList code = method.instructions;
        ListIterator iterator = code.iterator();
        if (iterator.hasNext()) {
            insn = (AbstractInsnNode)iterator.next();
            insn = insn.getNext().getNext();
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)Name.hooks_create16BArray.invokeStatic());
            toInsert.add((AbstractInsnNode)new FieldInsnNode(181, cn.name, "block16BArray", "[S"));
            method.instructions.insert(insn, toInsert);
        }
        iterator = code.iterator();
        while (iterator.hasNext()) {
            insn = (AbstractInsnNode)iterator.next();
            if (insn instanceof IntInsnNode && ((IntInsnNode)insn).operand == 4096) {
                ((IntInsnNode)insn).operand = 0;
            }
            if (!(insn instanceof InsnNode) || ((InsnNode)insn).getOpcode() != 89) continue;
            iterator.next();
            iterator.remove();
            iterator.next();
            iterator.remove();
            iterator.next();
            iterator.remove();
            iterator.add(new IntInsnNode(17, 4096));
        }
        method.maxStack = Math.max(method.maxStack, 2);
    }

    private void transformGetBlock(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        code.clear();
        code.add((AbstractInsnNode)new VarInsnNode(25, 0));
        code.add((AbstractInsnNode)new VarInsnNode(21, 1));
        code.add((AbstractInsnNode)new VarInsnNode(21, 2));
        code.add((AbstractInsnNode)new VarInsnNode(21, 3));
        code.add((AbstractInsnNode)Name.hooks_getBlockById.invokeStatic());
        code.add((AbstractInsnNode)new InsnNode(176));
        method.localVariables = null;
        method.maxStack = 4;
    }

    private void transformSetBlock(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        int part = 0;
        ListIterator iterator = code.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (part == 0) {
                iterator.remove();
                if (insn.getOpcode() != 184) continue;
                ++part;
                iterator.add(new VarInsnNode(25, 0));
                iterator.add(new VarInsnNode(21, 1));
                iterator.add(new VarInsnNode(21, 2));
                iterator.add(new VarInsnNode(21, 3));
                iterator.add(Name.ebs_getBlock.invokeSpecial());
                continue;
            }
            if (part == 1) {
                if (insn.getOpcode() != 184) continue;
                iterator.set(new VarInsnNode(25, 6));
                iterator.add(Name.hooks_getIdFromBlockWithCheck.invokeStatic());
                ++part;
                continue;
            }
            iterator.remove();
        }
        if (part != 2) {
            throw new AsmTransformException("no match for part " + part);
        }
        code.add((AbstractInsnNode)new VarInsnNode(54, 5));
        code.add((AbstractInsnNode)new VarInsnNode(25, 0));
        code.add((AbstractInsnNode)new VarInsnNode(21, 1));
        code.add((AbstractInsnNode)new VarInsnNode(21, 2));
        code.add((AbstractInsnNode)new VarInsnNode(21, 3));
        code.add((AbstractInsnNode)new VarInsnNode(21, 5));
        code.add((AbstractInsnNode)Name.hooks_setBlockId.invokeStatic());
        code.add((AbstractInsnNode)new InsnNode(177));
        method.localVariables = null;
        --method.maxLocals;
        method.maxStack = Math.max(method.maxStack, 5);
    }

    private void transformGetBlockMSBArray(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        code.clear();
        code.add((AbstractInsnNode)new InsnNode(1));
        code.add((AbstractInsnNode)new InsnNode(176));
        method.localVariables = null;
        method.maxStack = 1;
    }

    private void transformRemoveInvalidBlocks(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        code.clear();
        code.add((AbstractInsnNode)new VarInsnNode(25, 0));
        code.add((AbstractInsnNode)new MethodInsnNode(184, "ru/fewizz/idextender/Hooks", "removeInvalidBlocksHook", "(L" + cn.name + ";)V", false));
        code.add((AbstractInsnNode)new InsnNode(177));
        method.localVariables = null;
        method.maxStack = 1;
    }
}

