/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.idextender.asm.transformer;

import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import ru.fewizz.idextender.asm.AsmTransformException;
import ru.fewizz.idextender.asm.AsmUtil;
import ru.fewizz.idextender.asm.IClassNodeTransformer;
import ru.fewizz.idextender.asm.Name;

public class VanillaAnvilChunkLoader
implements IClassNodeTransformer {
    @Override
    public void transform(ClassNode cn) {
        MethodNode method = AsmUtil.findMethod(cn, Name.acl_writeChunkToNBT);
        this.transformWriteChunkToNBT(cn, method);
        method = AsmUtil.findMethod(cn, Name.acl_readChunkFromNBT);
        this.transformReadChunkFromNBT(cn, method);
    }

    private void transformWriteChunkToNBT(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        ListIterator iterator = code.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (insn.getOpcode() != 18 || !((LdcInsnNode)insn).cst.equals("Blocks")) continue;
            iterator.remove();
            iterator.next();
            iterator.next();
            iterator.remove();
            iterator.next();
            iterator.remove();
            iterator.add(Name.hooks_writeChunkToNbt.invokeStatic());
            return;
        }
        throw new AsmTransformException("can't find Blocks LDC");
    }

    private void transformReadChunkFromNBT(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        int part = 0;
        ListIterator iterator = code.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            if (part == 0) {
                if (insn.getOpcode() != 18 || !((LdcInsnNode)insn).cst.equals("Blocks")) continue;
                iterator.set(Name.hooks_readChunkFromNbt.invokeStatic());
                ++part;
                continue;
            }
            if (part == 1) {
                MethodInsnNode node;
                iterator.remove();
                if (insn.getOpcode() != 182 || !Name.ebs_setBlockMSBArray.matches(node = (MethodInsnNode)insn)) continue;
                ++part;
                continue;
            }
            if (insn.getType() != 14) continue;
            iterator.remove();
            ++part;
            break;
        }
        if (part != 3) {
            throw new AsmTransformException("no match for part " + part);
        }
    }
}

