/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.idextender.asm.transformer;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import ru.fewizz.idextender.asm.AsmUtil;
import ru.fewizz.idextender.asm.IClassNodeTransformer;
import ru.fewizz.idextender.asm.Name;

public class SelfHooks
implements IClassNodeTransformer {
    @Override
    public void transform(ClassNode cn) {
        MethodNode method = AsmUtil.findMethod(cn, "get");
        this.transformGet(cn, method);
        method = AsmUtil.findMethod(cn, "setBlockRefCount");
        this.transformSetBlockRefCount(cn, method);
        method = AsmUtil.findMethod(cn, "setTickRefCount");
        this.transformSetTickRefCount(cn, method);
    }

    private void transformGet(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        code.clear();
        code.add((AbstractInsnNode)new VarInsnNode(25, 0));
        code.add((AbstractInsnNode)new FieldInsnNode(180, Type.getArgumentTypes((String)method.desc)[0].getInternalName(), "block16BArray", "[S"));
        code.add((AbstractInsnNode)new InsnNode(176));
        method.localVariables = null;
        method.maxStack = 1;
    }

    private void transformSetBlockRefCount(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        code.clear();
        code.add((AbstractInsnNode)new VarInsnNode(25, 0));
        code.add((AbstractInsnNode)new VarInsnNode(21, 1));
        code.add((AbstractInsnNode)Name.ebs_blockRefCount.putField());
        code.add((AbstractInsnNode)new InsnNode(177));
        method.localVariables = null;
        method.maxStack = 2;
    }

    private void transformSetTickRefCount(ClassNode cn, MethodNode method) {
        InsnList code = method.instructions;
        code.clear();
        code.add((AbstractInsnNode)new VarInsnNode(25, 0));
        code.add((AbstractInsnNode)new VarInsnNode(21, 1));
        code.add((AbstractInsnNode)Name.ebs_tickRefCount.putField());
        code.add((AbstractInsnNode)new InsnNode(177));
        method.localVariables = null;
        method.maxStack = 2;
    }
}

