/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.idextender.asm;

import java.io.PrintWriter;
import java.util.ListIterator;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import ru.fewizz.idextender.asm.AsmTransformException;
import ru.fewizz.idextender.asm.FieldNotFoundException;
import ru.fewizz.idextender.asm.MethodNotFoundException;
import ru.fewizz.idextender.asm.Name;

public class AsmUtil
implements Opcodes {
    public static MethodNode findMethod(ClassNode cn, String name, String desc, boolean optional) {
        for (MethodNode ret : cn.methods) {
            if (!ret.name.equals(name) || desc != null && !ret.desc.equals(desc)) continue;
            return ret;
        }
        if (!optional) {
            throw new MethodNotFoundException(name);
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode cn, String name, boolean optional) {
        return AsmUtil.findMethod(cn, name, null, optional);
    }

    public static MethodNode findMethod(ClassNode cn, String name) {
        return AsmUtil.findMethod(cn, name, null, false);
    }

    public static MethodNode findMethod(ClassNode cn, Name name) {
        return AsmUtil.findMethod(cn, name, false);
    }

    public static MethodNode findMethod(ClassNode cn, Name name, boolean optional) {
        MethodNode m = AsmUtil.findMethod(cn, name.deobf, name.desc, true);
        if (m == null) {
            m = AsmUtil.findMethod(cn, name.srg, name.desc, true);
        }
        if (m == null) {
            m = AsmUtil.findMethod(cn, name.obf, name.obfDesc, true);
        }
        if (m == null && !optional) {
            throw new MethodNotFoundException(name.deobf);
        }
        return m;
    }

    public static FieldNode findField(ClassNode cn, String name, String desc, boolean optional) {
        for (FieldNode ret : cn.fields) {
            if (!name.equals(ret.name) || desc != null && !ret.desc.equals(desc)) continue;
            return ret;
        }
        if (!optional) {
            throw new FieldNotFoundException(name);
        }
        return null;
    }

    public static FieldNode findField(ClassNode cn, Name name, boolean optional) {
        FieldNode f = AsmUtil.findField(cn, name.deobf, name.desc, true);
        if (f == null) {
            f = AsmUtil.findField(cn, name.srg, name.desc, true);
        }
        if (f == null) {
            f = AsmUtil.findField(cn, name.obf, name.obfDesc, true);
        }
        if (f == null && !optional) {
            throw new MethodNotFoundException(name.deobf);
        }
        return f;
    }

    public static FieldNode findField(ClassNode cn, String name, boolean optional) {
        return AsmUtil.findField(cn, name, null, optional);
    }

    public static FieldNode findField(ClassNode cn, String name) {
        return AsmUtil.findField(cn, name, null, false);
    }

    public static FieldNode findField(ClassNode cn, Name name) {
        return AsmUtil.findField(cn, name, false);
    }

    public static void makePublic(MethodNode x) {
        x.access = x.access & 0xFFFFFFF9 | 1;
    }

    public static void makePublic(FieldNode x) {
        x.access = x.access & 0xFFFFFFF9 | 1;
    }

    public static boolean transformIntConst(ClassNode cn, String method, int oldValue, int newValue) {
        return AsmUtil.transformIntConst(cn, AsmUtil.findMethod(cn, method), oldValue, newValue, false);
    }

    public static boolean transformIntConst(ClassNode cn, Name method, int oldValue, int newValue) {
        return AsmUtil.transformIntConst(cn, AsmUtil.findMethod(cn, method), oldValue, newValue, false);
    }

    public static boolean transformIntConst(ClassNode cn, MethodNode method, int oldValue, int newValue) {
        return AsmUtil.transformIntConst(cn, method, oldValue, newValue, false);
    }

    static void setIntConst(InsnList il, AbstractInsnNode loc, int cst) {
        Object n = cst >= -1 && cst <= 5 ? new InsnNode(3 + cst) : (cst >= -128 && cst <= 127 ? new IntInsnNode(16, cst) : (cst >= Short.MIN_VALUE && cst <= Short.MAX_VALUE ? new IntInsnNode(17, cst) : new LdcInsnNode((Object)new Integer(cst))));
        il.set(loc, (AbstractInsnNode)n);
    }

    public static boolean transformIntConst(ClassNode cn, MethodNode method, int oldValue, int newValue, boolean optional) {
        int occur = 0;
        InsnList il = method.instructions;
        for (AbstractInsnNode insn : il) {
            if (insn.getOpcode() >= 2 && insn.getOpcode() <= 8 && oldValue == insn.getOpcode() - 3) {
                AsmUtil.setIntConst(il, insn, newValue);
            } else if ((insn.getOpcode() == 17 || insn.getOpcode() == 16) && ((IntInsnNode)insn).operand == oldValue) {
                AsmUtil.setIntConst(il, insn, newValue);
            } else {
                if (insn.getOpcode() != 18 || !((LdcInsnNode)insn).cst.equals(oldValue)) continue;
                AsmUtil.setIntConst(il, insn, newValue);
            }
            ++occur;
        }
        if (occur == 0 && !optional) {
            throw new AsmTransformException("can't find constant value " + oldValue + " in method " + method.name);
        }
        return occur > 0;
    }

    public static AbstractInsnNode find(AbstractInsnNode begin, InsnNodeSearcher s) {
        AbstractInsnNode res = null;
        AbstractInsnNode insn = begin;
        while (insn.getNext() != null) {
            Action a = s.test(insn);
            if (a == Action.FOUND_RETURN) {
                return insn;
            }
            if (a == Action.FOUND_CONTINUE) {
                res = insn;
            }
            insn = insn.getNext();
        }
        return res;
    }

    public static MethodInsnNode findMethodInsnNode(AbstractInsnNode begin, final Name name) {
        return (MethodInsnNode)AsmUtil.find(begin, new InsnNodeSearcher(){

            @Override
            Action test(AbstractInsnNode insn) {
                if (insn.getType() == 5 && name.matches((MethodInsnNode)insn)) {
                    return Action.FOUND_RETURN;
                }
                return Action.CONTINUE;
            }
        });
    }

    public static VarInsnNode findVarInsnNode(AbstractInsnNode begin, final int opcode, final int var) {
        return (VarInsnNode)AsmUtil.find(begin, new InsnNodeSearcher(){

            @Override
            Action test(AbstractInsnNode insn) {
                if (insn.getType() == 2 && insn.getOpcode() == opcode && ((VarInsnNode)insn).var == var) {
                    return Action.FOUND_RETURN;
                }
                return Action.CONTINUE;
            }
        });
    }

    public static IntInsnNode findIntInsnNode(AbstractInsnNode begin, final int val) {
        return (IntInsnNode)AsmUtil.find(begin, new InsnNodeSearcher(){

            @Override
            Action test(AbstractInsnNode insn) {
                if (insn.getType() == 1 && ((IntInsnNode)insn).operand == val) {
                    return Action.FOUND_RETURN;
                }
                return Action.CONTINUE;
            }
        });
    }

    public static MethodInsnNode findMethodInsnNode(AbstractInsnNode begin, final String name, final String desc) {
        return (MethodInsnNode)AsmUtil.find(begin, new InsnNodeSearcher(){

            @Override
            Action test(AbstractInsnNode insn) {
                if (insn.getType() == 5 && ((MethodInsnNode)insn).name.equals(name) && (desc == null || ((MethodInsnNode)insn).desc.equals(desc))) {
                    return Action.FOUND_RETURN;
                }
                return Action.CONTINUE;
            }
        });
    }

    public static InsnNode findInsnNode(AbstractInsnNode begin, final int opcode) {
        return (InsnNode)AsmUtil.find(begin, new InsnNodeSearcher(){

            @Override
            Action test(AbstractInsnNode insn) {
                if (insn.getOpcode() == opcode) {
                    return Action.FOUND_RETURN;
                }
                return Action.CONTINUE;
            }
        });
    }

    public static void removeRange(InsnList il, AbstractInsnNode begIn, AbstractInsnNode endEx) {
        ListIterator it = il.iterator(il.indexOf(begIn));
        if (it.hasNext()) {
            it.next();
            it.previous();
        } else if (it.hasPrevious()) {
            it.previous();
            it.next();
        } else {
            throw new RuntimeException();
        }
        while (begIn != endEx) {
            it.remove();
            begIn = (AbstractInsnNode)it.next();
        }
    }

    public static AbstractInsnNode getRelative(AbstractInsnNode insn, int way) {
        while (way != 0) {
            insn = way > 0 ? insn.getNext() : insn.getPrevious();
            way -= way / Math.abs(way);
        }
        return insn;
    }

    public static void dump(InsnList list) {
        Textifier textifier = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)textifier);
        list.accept((MethodVisitor)visitor);
        PrintWriter writer = new PrintWriter(System.out);
        textifier.print(writer);
        writer.flush();
    }

    public static abstract class InsnNodeSearcher {
        abstract Action test(AbstractInsnNode var1);
    }

    static enum Action {
        CONTINUE,
        FOUND_RETURN,
        FOUND_CONTINUE;

    }
}

