/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict;

import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.ResourceHandler;

public final class MetaItem {
    private static final FMLControlledNamespacedRegistry<Item> itemRegistry = GameData.getItemRegistry();

    private MetaItem() {
    }

    public static int get(ItemStack itemStack) {
        Item item;
        if (itemStack == null || (item = itemStack.func_77973_b()) == null) {
            return 0;
        }
        int id = itemRegistry.getId((Object)item);
        return id > 0 ? (item.getDamage(itemStack) == Short.MAX_VALUE ? id : id | item.getDamage(itemStack) + 1 << 16) : 0;
    }

    public static int get(Item item) {
        if (item == null) {
            return 0;
        }
        int id = itemRegistry.func_148757_b((Object)item);
        return id > 0 ? id | 0x10000 : 0;
    }

    public static ItemStack toItemStack(int metaItemKey) {
        return metaItemKey > 0 ? new ItemStack((Item)itemRegistry.getRaw(metaItemKey ^ metaItemKey & 0x10000), 0, metaItemKey >> 16) : null;
    }

    public static int getCumulative(Object[] objects, ResourceHandler resourceHandler) {
        int cumulativeKey = 0;
        for (Object object : objects) {
            if (object instanceof ItemStack) {
                cumulativeKey += MetaItem.get(resourceHandler.getMainItemStack((ItemStack)object));
                continue;
            }
            if (!(object instanceof List) || ((List)object).isEmpty()) continue;
            cumulativeKey += MetaItem.get((ItemStack)((List)object).get(0));
        }
        return cumulativeKey;
    }

    public static int getCumulative(ItemStack ... itemStacks) {
        int cumulativeKey = 0;
        for (ItemStack itemStack : itemStacks) {
            cumulativeKey += MetaItem.get(itemStack);
        }
        return cumulativeKey;
    }

    public static int[] getArray(Collection<ItemStack> itemStackCollection) {
        return MetaItem.getList(itemStackCollection).toArray();
    }

    public static TIntList getList(Collection<ItemStack> itemStackCollection) {
        TIntArrayList keys = new TIntArrayList();
        for (ItemStack itemStack : itemStackCollection) {
            int hash = MetaItem.get(itemStack);
            if (hash == 0) continue;
            keys.add(hash);
        }
        return keys;
    }

    public static TIntList getList(@Nonnull Object[] objects, @Nonnull ResourceHandler resourceHandler) {
        TIntArrayList keys = new TIntArrayList();
        for (Object object : objects) {
            int bufKey;
            if (object instanceof ItemStack) {
                bufKey = MetaItem.get(resourceHandler.getMainItemStack((ItemStack)object));
                if (bufKey <= 0) continue;
                keys.add(bufKey);
                continue;
            }
            if (!(object instanceof List) || ((List)object).isEmpty() || (bufKey = MetaItem.get((ItemStack)((List)object).get(0))) <= 0) continue;
            keys.add(bufKey);
        }
        return keys;
    }

    public static TIntSet getSet(Collection<Resource> resourceCollection, long kind) {
        TIntHashSet keys = new TIntHashSet();
        resourceCollection.stream().filter(resource -> (resource.getChildren() & kind) > 0L).forEach(arg_0 -> MetaItem.lambda$getSet$1((TIntSet)keys, kind, arg_0));
        return keys;
    }

    public static TIntSet getSet(Collection<ItemStack> itemStackCollection) {
        return new TIntHashSet((TIntCollection)MetaItem.getList(itemStackCollection));
    }

    public static <E> void populateMap(Collection<ItemStack> itemStackCollection, TIntObjectMap<E> map, E defaultValue) {
        for (int id : MetaItem.getArray(itemStackCollection)) {
            map.put(id, defaultValue);
        }
    }

    public static void populateMap(Collection<ItemStack> itemStackCollection, TIntLongMap map, long defaultValue) {
        for (int id : MetaItem.getArray(itemStackCollection)) {
            map.put(id, defaultValue);
        }
    }

    private static /* synthetic */ void lambda$getSet$1(TIntSet keys, long kind, Resource resource) {
        keys.addAll((TIntCollection)MetaItem.getList(resource.getChild(kind).getEntries()));
    }
}

