/*
 * Decompiled with CFR 0.152.
 */
package reauth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import reauth.Main;

class VersionChecker
implements Runnable {
    private static final String url = "https://raw.githubusercontent.com/TechnicianLP/ReAuth/master/version.json";
    private static final String group = "1.7.10";
    private static boolean isLatestVersion = true;
    private static String latestMessage = "\u00a7aUpdate Available!";
    private static boolean isVersionAllowed = true;
    private static String allowedMessage = "\u00a74Critical Update Available!";
    private static long run = 0L;

    VersionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Main.log.info("Looking for Updates");
        InputStream in = null;
        try {
            in = new URL(url).openStream();
            JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(in, "UTF-8")).getAsJsonObject();
            if (json.has(group)) {
                ComparableVersion rRecommended;
                ComparableVersion rLocal;
                JsonObject data = json.getAsJsonObject(group);
                String latest = data.getAsJsonPrimitive("latest").getAsString();
                latestMessage = "\u00a7aUpdate Available!";
                if (data.has("latest-message")) {
                    latestMessage = latestMessage + " - " + data.getAsJsonPrimitive("latest-message").getAsString();
                }
                String allowed = null;
                if (data.has("allowed")) {
                    allowed = data.getAsJsonPrimitive("allowed").getAsString();
                }
                allowedMessage = "\u00a74Critical Update Available!";
                if (data.has("allowed-message")) {
                    allowedMessage = allowedMessage + " - " + data.getAsJsonPrimitive("allowed-message").getAsString();
                }
                boolean bl = isLatestVersion = (rLocal = new ComparableVersion(Main.meta.version)).compareTo(rRecommended = new ComparableVersion(latest)) >= 0;
                if (allowed == null) {
                    isVersionAllowed = true;
                } else {
                    VersionRange rAllowed = VersionParser.parseRange((String)allowed);
                    isVersionAllowed = rAllowed.containsVersion((ArtifactVersion)new DefaultArtifactVersion(Main.meta.version));
                }
            } else {
                Main.log.error("Looking for Updates - Failed: Unknown Version: \"1.7.10\"");
            }
            run = System.currentTimeMillis();
            Main.log.info("Looking for Updates - Finished");
        }
        catch (Exception e) {
            try {
                Main.log.error("Looking for Updates - Failed", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
        return;
        run = System.currentTimeMillis() - 2700000L;
    }

    static boolean isLatestVersion() {
        return isLatestVersion;
    }

    static boolean isVersionAllowed() {
        return isVersionAllowed;
    }

    static String getUpdateMessage() {
        if (!isVersionAllowed) {
            return allowedMessage;
        }
        if (!isLatestVersion) {
            return latestMessage;
        }
        return null;
    }

    static boolean shouldRun() {
        return System.currentTimeMillis() - run > 3600000L;
    }

    static void update() {
        Thread t = new Thread((Runnable)new VersionChecker(), "ReAuth-VersionChecker");
        t.setDaemon(true);
        t.start();
    }
}

