/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.asm.IBiomeMixin;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonTime;

public class SeasonASMHelper {
    public static boolean canSnowAtInSeason(World world, int x, int y, int z, boolean checkLight, @Nullable ISeasonState seasonState) {
        return SeasonASMHelper.canSnowAtInSeason(world, x, y, z, checkLight, seasonState, false);
    }

    public static boolean canSnowAtInSeason(World world, int x, int y, int z, boolean checkLight, @Nullable ISeasonState seasonState, boolean useUnmodifiedTemperature) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        IBiomeMixin biomeMixin = (IBiomeMixin)biome;
        float temperature = biomeMixin.getFloatTemperatureOld(x, y, z);
        if (SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g) && BiomeConfig.enablesSeasonalEffects(biome) && !useUnmodifiedTemperature) {
            if (BiomeConfig.usesTropicalSeasons(biome)) {
                return false;
            }
            temperature = SeasonASMHelper.getFloatTemperature(world, biome, x, y, z);
        }
        if (temperature >= 0.15f) {
            return false;
        }
        if (biome.field_76750_F >= 0.15f && !ModConfig.seasons.generateSnowAndIce) {
            return false;
        }
        if (checkLight) {
            Block block;
            return y >= 0 && y < 256 && world.func_72972_b(EnumSkyBlock.Block, x, y, z) < 10 && (block = world.func_147439_a(x, y, z)).isAir((IBlockAccess)world, x, y, z) && Blocks.field_150431_aC.func_149742_c(world, x, y, z);
        }
        return true;
    }

    public static boolean canBlockFreezeInSeason(World world, int x, int y, int z, boolean noWaterAdj, @Nullable ISeasonState seasonState) {
        return SeasonASMHelper.canBlockFreezeInSeason(world, x, y, z, noWaterAdj, seasonState, false);
    }

    public static boolean canBlockFreezeInSeason(World world, int x, int y, int z, boolean noWaterAdj, @Nullable ISeasonState seasonState, boolean useUnmodifiedTemperature) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        IBiomeMixin biomeMixin = (IBiomeMixin)biome;
        float temperature = biomeMixin.getFloatTemperatureOld(x, y, z);
        if (SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g) && BiomeConfig.enablesSeasonalEffects(biome) && !useUnmodifiedTemperature) {
            if (BiomeConfig.usesTropicalSeasons(biome)) {
                return false;
            }
            temperature = SeasonASMHelper.getFloatTemperature(world, biome, x, y, z);
        }
        if (temperature >= 0.15f) {
            return false;
        }
        if (biome.field_76750_F >= 0.15f && !ModConfig.seasons.generateSnowAndIce) {
            return false;
        }
        if (y >= 0 && y < 256 && world.func_72972_b(EnumSkyBlock.Block, x, y, z) < 10) {
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && meta == 0) {
                boolean flag;
                if (!noWaterAdj) {
                    return true;
                }
                boolean bl = flag = SeasonASMHelper.isWater((IBlockAccess)world, x - 1, y, z) && SeasonASMHelper.isWater((IBlockAccess)world, x + 1, y, z) && SeasonASMHelper.isWater((IBlockAccess)world, x, y, z - 1) && SeasonASMHelper.isWater((IBlockAccess)world, x, y, z + 1);
                if (!flag) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isWater(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h;
    }

    public static boolean isRainingAtInSeason(World world, int x, int y, int z, ISeasonState seasonState) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        IBiomeMixin biomeMixin = (IBiomeMixin)biome;
        if (SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g) && BiomeConfig.usesTropicalSeasons(biome) && BiomeConfig.enablesSeasonalEffects(biome)) {
            Season.TropicalSeason tropicalSeason = seasonState.getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
            return biome.field_76765_S;
        }
        if (biomeMixin.getEnableSnowOld() || world.canSnowAtBody(x, y, z, false)) {
            return false;
        }
        return biome.field_76765_S;
    }

    public static float getFloatTemperature(World world, BiomeGenBase biome, int x, int y, int z) {
        if (!SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g)) {
            IBiomeMixin biomeMixin = (IBiomeMixin)biome;
            return biomeMixin.getFloatTemperatureOld(x, y, z);
        }
        return SeasonASMHelper.getFloatTemperature(new SeasonTime(SeasonHelper.getSeasonState(world).getSeasonCycleTicks()).getSubSeason(), biome, x, y, z);
    }

    public static float getFloatTemperature(Season.SubSeason subSeason, BiomeGenBase biome, int x, int y, int z) {
        boolean tropicalBiome = BiomeConfig.usesTropicalSeasons(biome);
        IBiomeMixin biomeMixin = (IBiomeMixin)biome;
        float biomeTemp = biomeMixin.getFloatTemperatureOld(x, y, z);
        if (!tropicalBiome && biome.field_76750_F <= 0.8f && BiomeConfig.enablesSeasonalEffects(biome)) {
            switch (subSeason) {
                default: {
                    break;
                }
                case LATE_SPRING: 
                case EARLY_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.1f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case MID_SPRING: 
                case MID_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.2f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_SPRING: 
                case LATE_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.4f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_WINTER: 
                case MID_WINTER: 
                case LATE_WINTER: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.8f), (float)-0.5f, (float)2.0f);
                }
            }
        }
        return biomeTemp;
    }

    public static boolean shouldRenderRainSnow(World world, BiomeGenBase biome) {
        IBiomeMixin biomeMixin = (IBiomeMixin)biome;
        if (SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g) && BiomeConfig.usesTropicalSeasons(biome) && BiomeConfig.enablesSeasonalEffects(biome)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(world).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
            return biome.field_76765_S || biomeMixin.getEnableSnowOld();
        }
        return biome.field_76765_S || biomeMixin.getEnableSnowOld();
    }

    public static boolean shouldAddRainParticles(World world, BiomeGenBase biome) {
        if (SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.field_76574_g) && BiomeConfig.usesTropicalSeasons(biome) && BiomeConfig.enablesSeasonalEffects(biome)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(world).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
            return biome.field_76765_S;
        }
        return biome.field_76765_S;
    }
}

