/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import sereneseasons.api.config.SeasonsOption;
import sereneseasons.api.config.SyncedConfig;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.handler.PacketHandler;
import sereneseasons.network.message.MessageSyncSeasonCycle;
import sereneseasons.season.SeasonASMHelper;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    private Season.SubSeason lastSeason = null;
    public static final HashMap<Integer, Integer> clientSeasonCycleTicks = new HashMap();

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && !world.field_72995_K) {
            MinecraftServer server;
            if (!SyncedConfig.getBooleanValue(SeasonsOption.PROGRESS_SEASON_WHILE_OFFLINE) && (server = FMLCommonHandler.instance().getMinecraftServerInstance()) != null && server.func_71233_x() == 0) {
                return;
            }
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            if (savedData.seasonCycleTicks++ > SeasonTime.ZERO.getCycleDuration()) {
                savedData.seasonCycleTicks = 0;
            }
            if (savedData.seasonCycleTicks % 20 == 0) {
                SeasonHandler.sendSeasonUpdate(world);
            }
            savedData.func_76185_a();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        SeasonHandler.sendSeasonUpdate(world);
    }

    public static SeasonTime getClientSeasonTime() {
        Integer i = clientSeasonCycleTicks.get(0);
        return new SeasonTime(i == null ? 0 : i);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        int dimension = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        if (event.phase == TickEvent.Phase.END && SeasonsConfig.isDimensionWhitelisted(dimension)) {
            SeasonTime calendar;
            clientSeasonCycleTicks.compute(dimension, (k, v) -> v == null ? 0 : v + 1);
            if (clientSeasonCycleTicks.get(dimension) > SeasonTime.ZERO.getCycleDuration()) {
                clientSeasonCycleTicks.put(dimension, 0);
            }
            if ((calendar = new SeasonTime(clientSeasonCycleTicks.get(dimension))).getSubSeason() != this.lastSeason) {
                Minecraft.func_71410_x().field_71438_f.func_72712_a();
                this.lastSeason = calendar.getSubSeason();
            }
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Populate event) {
        if (!event.world.field_72995_K && event.type != PopulateChunkEvent.Populate.EventType.ICE || !SeasonsConfig.isDimensionWhitelisted(event.world.field_73011_w.field_76574_g)) {
            return;
        }
        event.setResult(Event.Result.DENY);
        int x = event.chunkX * 16 + 8;
        int z = event.chunkZ * 16 + 8;
        for (int k2 = 0; k2 < 16; ++k2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                int y = event.world.func_72874_g(x + k2, z + j3);
                if (SeasonASMHelper.canBlockFreezeInSeason(event.world, x + k2, y - 1, z + j3, false, SeasonHelper.getSeasonState(event.world), true)) {
                    event.world.func_147449_b(x + k2, y - 1, z + j3, Blocks.field_150432_aD);
                }
                if (!SeasonASMHelper.canSnowAtInSeason(event.world, x + k2, y, z + j3, true, SeasonHelper.getSeasonState(event.world), true)) continue;
                event.world.func_147449_b(x + k2, y, z + j3, Blocks.field_150431_aC);
            }
        }
    }

    public static void sendSeasonUpdate(World world) {
        if (!world.field_72995_K) {
            SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
            PacketHandler.instance.sendToAll((IMessage)new MessageSyncSeasonCycle(world.field_73011_w.field_76574_g, savedData.seasonCycleTicks));
        }
    }

    public static SeasonSavedData getSeasonSavedData(World world) {
        MapStorage mapStorage = world.perWorldStorage;
        SeasonSavedData savedData = (SeasonSavedData)mapStorage.func_75742_a(SeasonSavedData.class, "seasons");
        if (savedData == null) {
            savedData = new SeasonSavedData("seasons");
            int startingSeason = SyncedConfig.getIntValue(SeasonsOption.STARTING_SUB_SEASON);
            if (startingSeason == 0) {
                savedData.seasonCycleTicks = world.field_73012_v.nextInt(12) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            if (startingSeason > 0) {
                savedData.seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            mapStorage.func_75745_a("seasons", (WorldSavedData)savedData);
            savedData.func_76185_a();
        }
        return savedData;
    }

    @Override
    public ISeasonState getServerSeasonState(World world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonState getClientSeasonState() {
        Integer i = clientSeasonCycleTicks.get(0);
        return new SeasonTime(i == null ? 0 : i);
    }
}

