/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonASMHelper;

public class RandomUpdateHandler {
    void turnIntoWater(World worldIn, int x, int y, int z) {
        if (worldIn.field_73011_w.field_76575_d) {
            worldIn.func_147468_f(x, y, z);
        } else {
            worldIn.func_147449_b(x, y, z, Blocks.field_150355_j);
            worldIn.func_147460_e(x, y, z, Blocks.field_150355_j);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        block16: {
            Season season;
            Season.SubSeason subSeason;
            block17: {
                if (event.phase != TickEvent.Phase.END || event.side != Side.SERVER) break block16;
                subSeason = SeasonHelper.getSeasonState(event.world).getSubSeason();
                season = subSeason.getSeason();
                if (season != Season.WINTER) break block17;
                if (!ModConfig.seasons.changeWeatherFrequency) break block16;
                if (event.world.func_72912_H().func_76061_m()) {
                    event.world.func_72912_H().func_76069_a(false);
                }
                if (event.world.func_72912_H().func_76059_o() || event.world.func_72912_H().func_76083_p() <= 36000) break block16;
                event.world.func_72912_H().func_76080_g(event.world.field_73012_v.nextInt(24000) + 12000);
                break block16;
            }
            if (ModConfig.seasons.changeWeatherFrequency) {
                if (season == Season.SPRING) {
                    if (!event.world.func_72912_H().func_76059_o() && event.world.func_72912_H().func_76083_p() > 96000) {
                        event.world.func_72912_H().func_76080_g(event.world.field_73012_v.nextInt(84000) + 12000);
                    }
                } else if (season == Season.SUMMER && !event.world.func_72912_H().func_76061_m() && event.world.func_72912_H().func_76071_n() > 36000) {
                    event.world.func_72912_H().func_76090_f(event.world.field_73012_v.nextInt(24000) + 12000);
                }
            }
            if (ModConfig.seasons.generateSnowAndIce && SeasonsConfig.isDimensionWhitelisted(event.world.field_73011_w.field_76574_g)) {
                WorldServer world = (WorldServer)event.world;
                ArrayList chunks = new ArrayList(world.field_73059_b.field_73245_g);
                block5: for (Chunk chunk : chunks) {
                    int rand;
                    int x = chunk.field_76635_g << 4;
                    int z = chunk.field_76647_h << 4;
                    switch (subSeason) {
                        case EARLY_SPRING: {
                            rand = 16;
                            break;
                        }
                        case MID_SPRING: {
                            rand = 12;
                            break;
                        }
                        case LATE_SPRING: {
                            rand = 8;
                            break;
                        }
                        default: {
                            rand = 4;
                        }
                    }
                    if (world.field_73012_v.nextInt(rand) != 0) continue;
                    world.field_73005_l = world.field_73005_l * 3 + 1013904223;
                    int randOffset = world.field_73005_l >> 2;
                    int yMax = world.func_72874_g(x += randOffset & 0xF, z += randOffset >> 8 & 0xF);
                    BiomeGenBase biome = world.func_72807_a(x, z);
                    if (!BiomeConfig.enablesSeasonalEffects(biome)) continue;
                    boolean first = true;
                    for (int y = yMax; y >= 0; --y) {
                        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
                        if (block == Blocks.field_150431_aC && SeasonASMHelper.getFloatTemperature((World)world, biome, x, y, z) >= 0.15f) {
                            world.func_147468_f(x, y, z);
                            continue block5;
                        }
                        if (!first) {
                            if (block != Blocks.field_150432_aD || !(SeasonASMHelper.getFloatTemperature((World)world, biome, x, y, z) >= 0.15f)) continue;
                            this.turnIntoWater((World)world, x, y, z);
                            continue block5;
                        }
                        first = false;
                    }
                }
            }
        }
    }
}

