/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.asm.transformer;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ColorTransformer
implements IClassTransformer {
    private static boolean fixedTransformerOrder = false;

    private void fixTransformerOrder() {
        if (fixedTransformerOrder) {
            return;
        }
        fixedTransformerOrder = true;
        try {
            Class<?> classLaunchClassLoader = Class.forName("net.minecraft.launchwrapper.LaunchClassLoader");
            Field fieldTransformers = classLaunchClassLoader.getDeclaredField("transformers");
            fieldTransformers.setAccessible(true);
            ArrayList<IClassTransformer> transformers = (ArrayList<IClassTransformer>)fieldTransformers.get(Launch.classLoader);
            transformers = new ArrayList<IClassTransformer>(transformers);
            IClassTransformer foundColorTransformer = null;
            for (IClassTransformer transformer : transformers) {
                if (!(transformer instanceof ColorTransformer)) continue;
                foundColorTransformer = transformer;
            }
            if (foundColorTransformer != null) {
                transformers.remove(foundColorTransformer);
                transformers.add(foundColorTransformer);
            }
            fieldTransformers.set(Launch.classLoader, transformers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        boolean transform = ColorTransformer.isBlock(classReader);
        if (!transform) {
            return bytes;
        }
        this.fixTransformerOrder();
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean changed = false;
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("colorMultiplier") && !methodNode.name.equals("func_149720_d") && (!methodNode.name.equals("d") || !methodNode.desc.equals("(Lahl;III)I"))) continue;
            methodNode.name = "colorMultiplierOld";
            changed = true;
            for (int i = 0; i < methodNode.instructions.size(); ++i) {
                AbstractInsnNode instruction = methodNode.instructions.get(i);
                if (instruction.getOpcode() != 183) continue;
                MethodInsnNode superCall = (MethodInsnNode)instruction;
                if (!superCall.name.equals("colorMultiplier") && !superCall.name.equals("func_149720_d") && (!superCall.name.equals("d") || !superCall.desc.equals("(Lahl;III)I"))) continue;
                superCall.name = "colorMultiplierOld";
            }
        }
        if (changed) {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            System.out.println("Transformed " + transformedName);
        }
        return bytes;
    }

    public static boolean isBlock(ClassReader classReader) {
        String superClassName = classReader.getSuperName();
        while (!superClassName.equals("java/lang/Object")) {
            if ((superClassName = FMLDeobfuscatingRemapper.INSTANCE.unmap(superClassName)).equals("net/minecraft/block/Block") || superClassName.equals("aji")) {
                return true;
            }
            try {
                classReader = new ClassReader(superClassName);
                superClassName = classReader.getSuperName();
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

