/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.ghast;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.MobHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ghast.EntityMeleeGhast;

public class EntityUnholyGhast
extends EntityMeleeGhast {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "ghast/unholy.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "ghast/unholy_shooting.png")};

    public EntityUnholyGhast(World world) {
        super(world);
        this.func_70105_a(2.0f, 2.0f);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().resetRenderScale(0.5f);
        this.field_70728_aV += 4;
    }

    @Override
    protected void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 2.0);
        this.getSpecialData().multAttribute(SharedMonsterAttributes.field_111263_d, 1.2);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        float damageLimit;
        float f = damageLimit = MobHelper.isCritical(damageSource) ? 1.0f : 0.5f;
        if (damage > damageLimit && !this.isDamageSourceEffective(damageSource)) {
            damage = damageLimit;
        }
        return super.func_70097_a(damageSource, damage);
    }

    public boolean isDamageSourceEffective(DamageSource damageSource) {
        if (damageSource != null) {
            ItemStack heldItem;
            if (damageSource.func_76357_e()) {
                return true;
            }
            Entity attacker = damageSource.func_76346_g();
            if (attacker instanceof EntityLivingBase && (heldItem = ((EntityLivingBase)attacker).func_70694_bm()) != null) {
                NBTTagCompound tinkerTag;
                if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77339_k.field_77352_x, (ItemStack)heldItem) > 0) {
                    return true;
                }
                if (heldItem.func_77942_o() && (tinkerTag = heldItem.func_77978_p().func_74775_l("InfiTool")).func_74764_b("ModSmite") && tinkerTag.func_74759_k("ModSmite")[0] > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        int i = this.field_70146_Z.nextInt(3 + looting);
        while (i-- > 0) {
            this.func_145779_a(Items.field_151043_k, 1);
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack drop = new ItemStack(Items.field_151010_B);
        EffectHelper.setItemName(drop, "Excalibur", 13);
        drop.func_77966_a(Enchantment.field_77339_k, 10);
        drop.func_77966_a(Enchantment.field_77334_n, this.field_70146_Z.nextInt(2) + 1);
        drop.func_77966_a(Enchantment.field_77347_r, 3);
        this.func_70099_a(drop, 0.0f);
    }
}

