/*
 * Decompiled with CFR 0.152.
 */
package com.fabiulu.farlanders.common.worldgen.village;

import com.fabiulu.farlanders.common.FarlandersMod;
import com.fabiulu.farlanders.common.worldgen.village.VillageRoad;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class VillageWell
extends WorldGenerator {
    private static final Block air = Blocks.field_150350_a;

    protected Block[] GetValidSpawnBlocks() {
        return new Block[]{Blocks.field_150433_aE, Blocks.field_150354_m, Blocks.field_150348_b, Blocks.field_150349_c};
    }

    public boolean LocationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        Block checkID = world.func_147439_a(i, j, k);
        while (checkID != air) {
            checkID = world.func_147439_a(i, j + ++distanceToAir, k);
        }
        if (distanceToAir > 2) {
            return false;
        }
        Block blockID = world.func_147439_a(i, j += distanceToAir - 1, k);
        Block blockIDAbove = world.func_147439_a(i, j + 1, k);
        Block blockIDBelow = world.func_147439_a(i, j - 1, k);
        for (Block x : this.GetValidSpawnBlocks()) {
            if (blockIDAbove != air) {
                return false;
            }
            if (blockID == Blocks.field_150433_aE && blockIDBelow == x || blockID == Blocks.field_150329_H && blockIDBelow == x || blockID == Blocks.field_150328_O && blockIDBelow == x || blockID == Blocks.field_150327_N && blockIDBelow == x || blockID == Blocks.field_150330_I && blockIDBelow == x || blockID == Blocks.field_150434_aF && blockIDBelow == x || blockID == Blocks.field_150338_P && blockIDBelow == x || blockID == Blocks.field_150337_Q && blockIDBelow == x) {
                return true;
            }
            if (blockID != x) continue;
            return true;
        }
        return false;
    }

    public boolean AirLocationIsValidSpawn(World world, int i, int j, int k) {
        Block blockID = world.func_147439_a(i, j, k);
        Block blockIDAbove = world.func_147439_a(i, j + 1, k);
        return blockID == air && blockIDAbove == air;
    }

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        Block whiteStone = Blocks.field_150377_bs;
        if (!(this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 5, j, k) && this.LocationIsValidSpawn(world, i + 5, j, k + 5) && this.LocationIsValidSpawn(world, i, j, k + 5) && this.AirLocationIsValidSpawn(world, i, j + 4, k) && this.AirLocationIsValidSpawn(world, i + 5, j + 4, k) && this.AirLocationIsValidSpawn(world, i + 5, j + 4, k + 5) && this.AirLocationIsValidSpawn(world, i, j + 4, k + 5))) {
            return false;
        }
        if (world.func_147439_a(i, j, k) == Blocks.field_150354_m && rand.nextInt((50 - FarlandersMod.villageSpawnRate) * 500) != 1) {
            return false;
        }
        if (!new VillageRoad().canAllHousesSpawn(world, i, j, k)) {
            return false;
        }
        world.func_147449_b(i + 0, j + 1, k + 0, air);
        world.func_147449_b(i + 0, j + 1, k + 1, air);
        world.func_147449_b(i + 0, j + 1, k + 2, air);
        world.func_147449_b(i + 0, j + 1, k + 3, air);
        world.func_147449_b(i + 0, j + 1, k + 4, air);
        world.func_147449_b(i + 0, j + 1, k + 5, air);
        world.func_147449_b(i + 0, j + 2, k + 0, air);
        world.func_147449_b(i + 0, j + 2, k + 1, air);
        world.func_147449_b(i + 0, j + 2, k + 2, air);
        world.func_147449_b(i + 0, j + 2, k + 3, air);
        world.func_147449_b(i + 0, j + 2, k + 4, air);
        world.func_147449_b(i + 0, j + 2, k + 5, air);
        world.func_147449_b(i + 0, j + 3, k + 0, air);
        world.func_147449_b(i + 0, j + 3, k + 1, air);
        world.func_147449_b(i + 0, j + 3, k + 2, air);
        world.func_147449_b(i + 0, j + 3, k + 3, air);
        world.func_147449_b(i + 0, j + 3, k + 4, air);
        world.func_147449_b(i + 0, j + 3, k + 5, air);
        world.func_147449_b(i + 0, j + 4, k + 0, air);
        world.func_147449_b(i + 0, j + 4, k + 1, air);
        world.func_147449_b(i + 0, j + 4, k + 2, air);
        world.func_147449_b(i + 0, j + 4, k + 3, air);
        world.func_147449_b(i + 0, j + 4, k + 4, air);
        world.func_147449_b(i + 0, j + 4, k + 5, air);
        world.func_147465_d(i + 1, j + 0, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 0, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 0, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 0, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 1, j + 1, k + 0, air);
        world.func_147465_d(i + 1, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 1, j + 1, k + 5, air);
        world.func_147449_b(i + 1, j + 2, k + 0, air);
        world.func_147465_d(i + 1, j + 2, k + 1, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 1, j + 2, k + 2, air);
        world.func_147449_b(i + 1, j + 2, k + 3, air);
        world.func_147465_d(i + 1, j + 2, k + 4, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 1, j + 2, k + 5, air);
        world.func_147449_b(i + 1, j + 3, k + 0, air);
        world.func_147465_d(i + 1, j + 3, k + 1, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 1, j + 3, k + 2, air);
        world.func_147449_b(i + 1, j + 3, k + 3, air);
        world.func_147465_d(i + 1, j + 3, k + 4, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 1, j + 3, k + 5, air);
        world.func_147449_b(i + 1, j + 4, k + 0, air);
        world.func_147465_d(i + 1, j + 4, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 4, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 4, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 4, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 1, j + 4, k + 5, air);
        world.func_147465_d(i + 2, j + 0, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 0, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 2, j + 1, k + 0, air);
        world.func_147465_d(i + 2, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147449_b(i + 2, j + 1, k + 2, air);
        world.func_147449_b(i + 2, j + 1, k + 3, air);
        world.func_147465_d(i + 2, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 2, j + 1, k + 5, air);
        world.func_147449_b(i + 2, j + 2, k + 0, air);
        world.func_147449_b(i + 2, j + 2, k + 1, air);
        world.func_147449_b(i + 2, j + 2, k + 2, air);
        world.func_147449_b(i + 2, j + 2, k + 3, air);
        world.func_147449_b(i + 2, j + 2, k + 4, air);
        world.func_147449_b(i + 2, j + 2, k + 5, air);
        world.func_147449_b(i + 2, j + 3, k + 0, air);
        world.func_147449_b(i + 2, j + 3, k + 1, air);
        world.func_147449_b(i + 2, j + 3, k + 2, air);
        world.func_147449_b(i + 2, j + 3, k + 3, air);
        world.func_147449_b(i + 2, j + 3, k + 4, air);
        world.func_147449_b(i + 2, j + 3, k + 5, air);
        world.func_147449_b(i + 2, j + 4, k + 0, air);
        world.func_147465_d(i + 2, j + 4, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 4, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 4, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 4, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 2, j + 4, k + 5, air);
        world.func_147465_d(i + 3, j + 0, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 0, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 3, j + 1, k + 0, air);
        world.func_147465_d(i + 3, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147449_b(i + 3, j + 1, k + 2, air);
        world.func_147449_b(i + 3, j + 1, k + 3, air);
        world.func_147465_d(i + 3, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 3, j + 1, k + 5, air);
        world.func_147449_b(i + 3, j + 2, k + 0, air);
        world.func_147449_b(i + 3, j + 2, k + 1, air);
        world.func_147449_b(i + 3, j + 2, k + 2, air);
        world.func_147449_b(i + 3, j + 2, k + 3, air);
        world.func_147449_b(i + 3, j + 2, k + 4, air);
        world.func_147449_b(i + 3, j + 2, k + 5, air);
        world.func_147449_b(i + 3, j + 3, k + 0, air);
        world.func_147449_b(i + 3, j + 3, k + 1, air);
        world.func_147449_b(i + 3, j + 3, k + 2, air);
        world.func_147449_b(i + 3, j + 3, k + 3, air);
        world.func_147449_b(i + 3, j + 3, k + 4, air);
        world.func_147449_b(i + 3, j + 3, k + 5, air);
        world.func_147449_b(i + 3, j + 4, k + 0, air);
        world.func_147465_d(i + 3, j + 4, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 4, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 4, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 4, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 3, j + 4, k + 5, air);
        world.func_147465_d(i + 4, j + 0, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 0, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 0, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 0, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 1, k + 0, air);
        world.func_147465_d(i + 4, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 1, k + 5, air);
        world.func_147449_b(i + 4, j + 2, k + 0, air);
        world.func_147465_d(i + 4, j + 2, k + 1, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 4, j + 2, k + 2, air);
        world.func_147449_b(i + 4, j + 2, k + 3, air);
        world.func_147465_d(i + 4, j + 2, k + 4, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 4, j + 2, k + 5, air);
        world.func_147449_b(i + 4, j + 3, k + 0, air);
        world.func_147465_d(i + 4, j + 3, k + 1, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 4, j + 3, k + 2, air);
        world.func_147449_b(i + 4, j + 3, k + 3, air);
        world.func_147465_d(i + 4, j + 3, k + 4, Blocks.field_150422_aJ, 0, 2);
        world.func_147449_b(i + 4, j + 3, k + 5, air);
        world.func_147449_b(i + 4, j + 4, k + 0, air);
        world.func_147465_d(i + 4, j + 4, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 4, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 4, k + 5, air);
        world.func_147449_b(i + 5, j + 1, k + 0, air);
        world.func_147449_b(i + 5, j + 1, k + 1, air);
        world.func_147449_b(i + 5, j + 1, k + 2, air);
        world.func_147449_b(i + 5, j + 1, k + 3, air);
        world.func_147449_b(i + 5, j + 1, k + 4, air);
        world.func_147449_b(i + 5, j + 1, k + 5, air);
        world.func_147449_b(i + 5, j + 2, k + 0, air);
        world.func_147449_b(i + 5, j + 2, k + 1, air);
        world.func_147449_b(i + 5, j + 2, k + 2, air);
        world.func_147449_b(i + 5, j + 2, k + 3, air);
        world.func_147449_b(i + 5, j + 2, k + 4, air);
        world.func_147449_b(i + 5, j + 2, k + 5, air);
        world.func_147449_b(i + 5, j + 3, k + 0, air);
        world.func_147449_b(i + 5, j + 3, k + 1, air);
        world.func_147449_b(i + 5, j + 3, k + 2, air);
        world.func_147449_b(i + 5, j + 3, k + 3, air);
        world.func_147449_b(i + 5, j + 3, k + 4, air);
        world.func_147449_b(i + 5, j + 3, k + 5, air);
        world.func_147449_b(i + 5, j + 4, k + 0, air);
        world.func_147449_b(i + 5, j + 4, k + 1, air);
        world.func_147449_b(i + 5, j + 4, k + 2, air);
        world.func_147449_b(i + 5, j + 4, k + 3, air);
        world.func_147449_b(i + 5, j + 4, k + 4, air);
        world.func_147449_b(i + 5, j + 4, k + 5, air);
        world.func_147465_d(i + 0, j + 0, k + 0, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 0, j + 0, k + 1, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 0, j + 0, k + 2, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 0, j + 0, k + 3, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 0, j + 0, k + 4, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 0, j + 0, k + 5, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 1, j + 0, k + 0, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 1, j + 0, k + 5, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 2, j + 0, k + 0, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 2, j + 0, k + 5, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 3, j + 0, k + 0, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 3, j + 0, k + 5, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 4, j + 0, k + 0, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 4, j + 0, k + 5, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 5, j + 0, k + 0, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 5, j + 0, k + 1, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 5, j + 0, k + 2, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 5, j + 0, k + 3, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 5, j + 0, k + 4, Blocks.field_150351_n, 0, 2);
        world.func_147465_d(i + 5, j + 0, k + 5, Blocks.field_150351_n, 0, 2);
        world.func_147449_b(i + 2, j - 1, k + 2, air);
        world.func_147449_b(i + 2, j - 1, k + 3, air);
        world.func_147449_b(i + 3, j - 1, k + 2, air);
        world.func_147449_b(i + 3, j - 1, k + 3, air);
        for (int posX = i; posX <= i + 5; ++posX) {
            for (int posZ = k; posZ <= k + 5; ++posZ) {
                int posY = j - 1;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_147439_a(posX, posY, posZ) == air || world.func_147439_a(posX, posY, posZ) == Blocks.field_150329_H || world.func_147439_a(posX, posY, posZ) == Blocks.field_150434_aF || world.func_147439_a(posX, posY, posZ) == Blocks.field_150328_O || world.func_147439_a(posX, posY, posZ) == Blocks.field_150327_N || world.func_147439_a(posX, posY, posZ) == Blocks.field_150330_I || world.func_147439_a(posX, posY, posZ) == Blocks.field_150433_aE || world.func_147439_a(posX, posY, posZ) == Blocks.field_150355_j || world.func_147439_a(posX, posY, posZ) == Blocks.field_150353_l || world.func_147439_a(posX, posY, posZ) == Blocks.field_150338_P || world.func_147439_a(posX, posY, posZ) == Blocks.field_150337_Q || world.func_147439_a(posX, posY, posZ) == Blocks.field_150392_bi) {
                        world.func_147465_d(posX, posY, posZ, whiteStone, 0, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        world.func_147465_d(i + 2, j + 0, k + 2, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 2, j + 0, k + 3, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 3, j + 0, k + 2, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 3, j + 0, k + 3, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 2, j - 1, k + 2, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 2, j - 1, k + 3, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 3, j - 1, k + 2, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 3, j - 1, k + 3, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 2, j - 2, k + 2, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 2, j - 2, k + 3, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 3, j - 2, k + 2, Blocks.field_150355_j, 0, 2);
        world.func_147465_d(i + 3, j - 2, k + 3, (Block)Blocks.field_150486_ae, 0, 2);
        TileEntityChest chest = new TileEntityChest();
        world.func_147455_a(i + 3, j - 2, k + 3, (TileEntity)chest);
        for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
            int num = rand.nextInt(100);
            if (num == 0) {
                chest.func_70299_a(slot, new ItemStack(FarlandersMod.gemEndumium));
                continue;
            }
            if (num == 1) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151166_bC));
                continue;
            }
            if (num == 2) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151043_k));
                continue;
            }
            if (num == 3) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151042_j));
                continue;
            }
            if (num == 4) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151065_br));
                continue;
            }
            if (num == 5) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151072_bj));
                continue;
            }
            if (num == 6) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151044_h));
                continue;
            }
            if (num == 7) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151062_by));
                continue;
            }
            if (num == 8) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151070_bp));
                continue;
            }
            if (num == 9) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151123_aH));
                continue;
            }
            if (num == 10) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151075_bm));
                continue;
            }
            if (num == 11) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151064_bs));
                continue;
            }
            if (num == 12) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151016_H));
                continue;
            }
            if (num == 13) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151073_bk));
                continue;
            }
            if (num == 14) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151074_bl));
                continue;
            }
            if (num == 15) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151071_bq));
                continue;
            }
            if (num == 16) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151059_bz));
                continue;
            }
            if (num == 17) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151145_ak));
                continue;
            }
            if (num == 18) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151079_bi));
                continue;
            }
            if (num == 19) {
                chest.func_70299_a(slot, new ItemStack(Items.field_151061_bv));
                continue;
            }
            if (num == 20) {
                chest.func_70299_a(slot, new ItemStack(FarlandersMod.enderGolemHorn));
                continue;
            }
            if (num != 21) continue;
            chest.func_70299_a(slot, new ItemStack(FarlandersMod.titanHide));
        }
        new VillageRoad().func_76484_a(world, rand, i, j, k);
        return true;
    }
}

