/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MazePredicateMany<M extends MazeComponent<C>, C>
implements MazePredicate<M, C> {
    public final List<MazePredicate<M, C>> predicates = new ArrayList<MazePredicate<M, C>>();

    public MazePredicateMany() {
    }

    public MazePredicateMany(List<MazePredicate<M, C>> predicates) {
        this.predicates.addAll(predicates);
    }

    @SafeVarargs
    public MazePredicateMany(MazePredicate<M, C> ... predicates) {
        Collections.addAll(this.predicates, predicates);
    }

    @Override
    public boolean canPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        return this.predicates.stream().allMatch(p -> p.canPlace(maze, component));
    }

    @Override
    public void willPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        this.predicates.forEach(p -> p.willPlace(maze, component));
    }

    @Override
    public void didPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        this.predicates.forEach(p -> p.didPlace(maze, component));
    }

    @Override
    public void willUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        this.predicates.forEach(p -> p.willUnplace(maze, component));
    }

    @Override
    public void didUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<M, C> component) {
        this.predicates.forEach(p -> p.didUnplace(maze, component));
    }

    @Override
    public boolean isDirtyConnection(MazeRoom dest, MazeRoom source, C c) {
        return this.predicates.stream().allMatch(p -> p.isDirtyConnection(dest, source, c));
    }
}

