/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;

public abstract class NormalizedSimpleStack {
    public static Map<String, Set<Integer>> idWithUsedMetaData = Maps.newHashMap();
    private static Map<String, NormalizedSimpleStack> oreDictStacks = Maps.newHashMap();

    public static NormalizedSimpleStack getFor(String itemName, int damage) {
        Set<Object> usedMetadata;
        NSSItem normStack;
        try {
            normStack = new NSSItem(itemName, damage);
        }
        catch (Exception e) {
            PELogger.logFatal("Could not create NSSItem: " + e.getMessage());
            return null;
        }
        if (!idWithUsedMetaData.containsKey(normStack.itemName)) {
            usedMetadata = Sets.newHashSet();
            idWithUsedMetaData.put(normStack.itemName, (Set<Integer>)usedMetadata);
        } else {
            usedMetadata = idWithUsedMetaData.get(normStack.itemName);
        }
        usedMetadata.add(normStack.damage);
        return normStack;
    }

    public static NormalizedSimpleStack getFor(Block block) {
        return NormalizedSimpleStack.getFor(block, 0);
    }

    private static GameRegistry.UniqueIdentifier getUniqueIdentifierOrNull(Block block) {
        GameRegistry.UniqueIdentifier identifier;
        try {
            identifier = GameRegistry.findUniqueIdentifierFor((Block)block);
        }
        catch (Exception e) {
            PELogger.logFatal("Could not findUniqueIdentifierFor(%s)", block != null ? block.getClass().getName() : "null");
            e.printStackTrace();
            return null;
        }
        return identifier;
    }

    public static NormalizedSimpleStack getFor(Block block, int meta) {
        return NormalizedSimpleStack.getFor(NormalizedSimpleStack.getUniqueIdentifierOrNull(block), meta);
    }

    public static NormalizedSimpleStack getFor(Item item) {
        return NormalizedSimpleStack.getFor(item, 0);
    }

    private static GameRegistry.UniqueIdentifier getUniqueIdentifierOrNull(Item item) {
        GameRegistry.UniqueIdentifier identifier;
        try {
            identifier = GameRegistry.findUniqueIdentifierFor((Item)item);
        }
        catch (Exception e) {
            PELogger.logFatal("Could not findUniqueIdentifierFor(%s)", item != null ? item.getClass().getName() : "null");
            e.printStackTrace();
            return null;
        }
        return identifier;
    }

    public static NormalizedSimpleStack getFor(Item item, int meta) {
        return NormalizedSimpleStack.getFor(NormalizedSimpleStack.getUniqueIdentifierOrNull(item), meta);
    }

    private static NormalizedSimpleStack getFor(GameRegistry.UniqueIdentifier uniqueIdentifier, int damage) {
        if (uniqueIdentifier == null) {
            return null;
        }
        return NormalizedSimpleStack.getFor(uniqueIdentifier.modId + ":" + uniqueIdentifier.name, damage);
    }

    public static NormalizedSimpleStack getFor(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        return NormalizedSimpleStack.getFor(stack.func_77973_b(), stack.func_77960_j());
    }

    public static NormalizedSimpleStack getFor(Fluid fluid) {
        return new NSSFluid(fluid);
    }

    public static <V extends Comparable<V>> void addMappings(IMappingCollector<NormalizedSimpleStack, V> mapper) {
        for (Map.Entry<String, Set<Integer>> entry : idWithUsedMetaData.entrySet()) {
            entry.getValue().remove(Short.MAX_VALUE);
            entry.getValue().add(0);
            NSSItem stackWildcard = new NSSItem(entry.getKey(), Short.MAX_VALUE);
            for (int metadata : entry.getValue()) {
                mapper.addConversion(1, (NormalizedSimpleStack)stackWildcard, Arrays.asList(new NSSItem(entry.getKey(), metadata)));
            }
        }
        for (Map.Entry<String, Object> entry : oreDictStacks.entrySet()) {
            NormalizedSimpleStack oreDictStack = (NormalizedSimpleStack)entry.getValue();
            List<ItemStack> list = ItemHelper.getODItems(entry.getKey());
            for (ItemStack i : list) {
                mapper.addConversion(1, oreDictStack, Arrays.asList(NormalizedSimpleStack.getFor(i)));
                mapper.addConversion(1, NormalizedSimpleStack.getFor(i), Arrays.asList(oreDictStack));
            }
        }
    }

    public abstract boolean equals(Object var1);

    public abstract String json();

    public static NormalizedSimpleStack forOreDictionary(String oreDictionaryName) {
        if (oreDictStacks.containsKey(oreDictionaryName)) {
            return oreDictStacks.get(oreDictionaryName);
        }
        ArrayList list = OreDictionary.getOres((String)oreDictionaryName);
        if (list == null || list.size() == 0) {
            return null;
        }
        NSSOreDictionary nss = new NSSOreDictionary(oreDictionaryName);
        oreDictStacks.put(oreDictionaryName, nss);
        return nss;
    }

    public static NormalizedSimpleStack createFake(String description) {
        return new NSSFake(description);
    }

    public static NormalizedSimpleStack fromSerializedItem(String serializedItem) {
        int itemDamage;
        int pipeIndex = serializedItem.lastIndexOf(124);
        if (pipeIndex < 0) {
            throw new IllegalArgumentException(String.format("Cannot parse '%s' as itemstack. Missing | to separate metadata.", serializedItem));
        }
        String itemName = serializedItem.substring(0, pipeIndex);
        String itemDamageString = serializedItem.substring(pipeIndex + 1);
        if (itemDamageString.equals("*")) {
            itemDamage = Short.MAX_VALUE;
        } else {
            try {
                itemDamage = Integer.parseInt(itemDamageString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Could not parse '%s' to metadata-integer", itemDamageString), e);
            }
        }
        return NormalizedSimpleStack.getFor(itemName, itemDamage);
    }

    public static class NSSOreDictionary
    extends NormalizedSimpleStack {
        public final String od;

        private NSSOreDictionary(String od) {
            this.od = od;
        }

        public int hashCode() {
            return this.od.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof NSSOreDictionary) {
                return this.od.equals(((NSSOreDictionary)o).od);
            }
            return false;
        }

        @Override
        public String json() {
            return "OD|" + this.od;
        }

        public String toString() {
            return "OD: " + this.od;
        }
    }

    public static class NSSFluid
    extends NormalizedSimpleStack {
        public final String name;

        private NSSFluid(Fluid f) {
            this.name = f.getName();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof NSSFluid) {
                return this.name.equals(((NSSFluid)o).name);
            }
            return false;
        }

        @Override
        public String json() {
            return "FLUID|" + this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Fluid: " + this.name;
        }
    }

    public static class NSSFake
    extends NormalizedSimpleStack {
        public final String description;
        public final int counter = fakeItemCounter++;
        private static int fakeItemCounter = 0;

        public NSSFake(String description) {
            this.description = description;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof NSSFake) {
                return o == this;
            }
            return false;
        }

        @Override
        public String json() {
            return "FAKE|" + this.counter + " " + this.description;
        }

        public String toString() {
            return "NSSFAKE" + this.counter + ": " + this.description;
        }
    }

    public static class NSSItem
    extends NormalizedSimpleStack {
        public final String itemName;
        public final int damage;

        private NSSItem(String itemName, int damage) {
            this.itemName = itemName;
            if (Item.field_150901_e.func_82594_a(itemName) == null) {
                throw new IllegalArgumentException("Invalid Item with itemName = " + itemName);
            }
            this.damage = damage;
        }

        public int hashCode() {
            return this.itemName.hashCode() ^ this.damage;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof NSSItem) {
                NSSItem other = (NSSItem)obj;
                return this.itemName.equals(other.itemName) && this.damage == other.damage;
            }
            return false;
        }

        @Override
        public String json() {
            return String.format("%s|%s", this.itemName, this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
        }

        public String toString() {
            Object obj = Item.field_150901_e.func_82594_a(this.itemName);
            if (obj != null) {
                return String.format("%s(%s:%s)", this.itemName, Item.field_150901_e.func_148757_b(obj), this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
            }
            return String.format("%s(???:%s)", this.itemName, this.damage == Short.MAX_VALUE ? "*" : Integer.valueOf(this.damage));
        }
    }
}

