/*
 * Decompiled with CFR 0.152.
 */
package radixcore.data;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.data.AbstractPlayerData;
import radixcore.data.WatchedObjectEx;
import radixcore.packets.PacketWatchedUpdateC;
import radixcore.packets.PacketWatchedUpdateS;
import radixcore.util.RadixExcept;

public final class DataWatcherEx
implements Serializable {
    public static final long serialVersionUID = 5724026292501184283L;
    public static boolean allowClientSideModification = false;
    private static final transient HashMap dataTypes = new HashMap();
    private String initializingModId;
    private Map watchedObjects = new HashMap();
    private final Entity entityOwner;
    private Object objectOwner;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public DataWatcherEx(Object owner, String modId) {
        this.entityOwner = null;
        this.objectOwner = owner;
        this.initializingModId = modId;
    }

    public DataWatcherEx(Entity owner, String modId) {
        this.entityOwner = owner;
        this.objectOwner = null;
        this.initializingModId = modId;
    }

    public void addObject(int id, Object value) {
        Integer dataType = (Integer)dataTypes.get(value.getClass());
        if (dataType == null) {
            throw new IllegalArgumentException("Unknown data type: " + value.getClass());
        }
        if (id > 255) {
            throw new IllegalArgumentException("Provided id value is too high! Maximum is 255.");
        }
        if (this.watchedObjects.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate id value for " + id + "!");
        }
        WatchedObjectEx watchableobject = new WatchedObjectEx(dataType, id, value);
        this.lock.writeLock().lock();
        this.watchedObjects.put(id, watchableobject);
        this.lock.writeLock().unlock();
    }

    public byte getWatchableObjectByte(int id) {
        return (Byte)this.getWatchedObject(id).getObject();
    }

    public short getWatchableObjectShort(int id) {
        return (Short)this.getWatchedObject(id).getObject();
    }

    public int getWatchableObjectInt(int id) {
        return (Integer)this.getWatchedObject(id).getObject();
    }

    public float getWatchableObjectFloat(int id) {
        return ((Float)this.getWatchedObject(id).getObject()).floatValue();
    }

    public String getWatchableObjectString(int id) {
        return (String)this.getWatchedObject(id).getObject();
    }

    public WatchedObjectEx getWatchedObject(int id) {
        this.lock.readLock().lock();
        WatchedObjectEx watchableobject = null;
        try {
            watchableobject = (WatchedObjectEx)this.watchedObjects.get(id);
        }
        catch (Throwable throwable) {
            RadixExcept.logFatalCatch(throwable, "Error getting watched object data.");
        }
        this.lock.readLock().unlock();
        return watchableobject;
    }

    public Map getWatchedDataMap() {
        return this.watchedObjects;
    }

    public void updateObject(int id, Object newValue, boolean dispatch) {
        WatchedObjectEx watchableObject = this.getWatchedObject(id);
        watchableObject.setObject(newValue);
        if (!RadixCore.isTesting && (this.entityOwner != null || this.objectOwner != null) && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketWatchedUpdateC packet = null;
            NetworkRegistry.TargetPoint point = null;
            if (this.entityOwner != null) {
                packet = new PacketWatchedUpdateC(this.entityOwner.func_145782_y(), id, newValue);
                point = new NetworkRegistry.TargetPoint(this.entityOwner.field_71093_bK, this.entityOwner.field_70165_t, this.entityOwner.field_70163_u, this.entityOwner.field_70161_v, 50.0);
            } else {
                packet = new PacketWatchedUpdateC(this.initializingModId, id, newValue);
            }
            if (point == null) {
                RadixCore.getPacketHandler().sendPacketToAllPlayers(packet);
            } else {
                RadixCore.getPacketHandler().sendPacketToAllAround(packet, point);
            }
            if (this.objectOwner instanceof AbstractPlayerData) {
                for (ModMetadataEx metadata : RadixCore.getRegisteredMods()) {
                    if (!metadata.modId.equals(this.initializingModId)) continue;
                    AbstractPlayerData data = (AbstractPlayerData)this.objectOwner;
                    if (data.owner == null) {
                        metadata.playerDataMap.put(data.ownerIdentifier, data);
                        continue;
                    }
                    metadata.playerDataMap.put(data.owner.func_110124_au().toString(), data);
                }
            }
        } else if (dispatch) {
            if (allowClientSideModification) {
                PacketWatchedUpdateS packet = null;
                packet = this.entityOwner != null ? new PacketWatchedUpdateS(this.entityOwner.func_145782_y(), id, newValue) : new PacketWatchedUpdateS(this.initializingModId, id, newValue);
                RadixCore.getPacketHandler().sendPacketToServer(packet);
            } else {
                RadixExcept.logErrorCatch(new Throwable(), "Attempted to modify watched value client-side without qualifying that this was intended!");
            }
        }
    }

    public void writeDataWatcherToNBT(NBTTagCompound nbt) {
        try {
            block9: for (Object object : this.watchedObjects.values()) {
                WatchedObjectEx watchableObject = (WatchedObjectEx)object;
                switch (watchableObject.getObjectType()) {
                    case Byte: {
                        nbt.func_74774_a("dataWatcherExObject" + watchableObject.getDataValueId(), ((Byte)watchableObject.getObject()).byteValue());
                        continue block9;
                    }
                    case Float: {
                        nbt.func_74776_a("dataWatcherExObject" + watchableObject.getDataValueId(), ((Float)watchableObject.getObject()).floatValue());
                        continue block9;
                    }
                    case Integer: {
                        nbt.func_74768_a("dataWatcherExObject" + watchableObject.getDataValueId(), ((Integer)watchableObject.getObject()).intValue());
                        continue block9;
                    }
                    case Short: {
                        nbt.func_74777_a("dataWatcherExObject" + watchableObject.getDataValueId(), ((Short)watchableObject.getObject()).shortValue());
                        continue block9;
                    }
                    case String: {
                        nbt.func_74778_a("dataWatcherExObject" + watchableObject.getDataValueId(), (String)watchableObject.getObject());
                        continue block9;
                    }
                }
                RadixExcept.logErrorCatch(new Throwable(), "Error writing watched object " + watchableObject.getDataValueId() + " to NBT. Invalid data type.");
            }
        }
        catch (Exception e) {
            RadixExcept.logErrorCatch(e, "Error saving data watcher to NBT.");
        }
    }

    public void readDataWatcherFromNBT(NBTTagCompound nbt) {
        try {
            block9: for (Object object : this.watchedObjects.values()) {
                WatchedObjectEx watchableObject = (WatchedObjectEx)object;
                switch (watchableObject.getObjectType()) {
                    case Byte: {
                        watchableObject.setObject(nbt.func_74771_c("dataWatcherExObject" + watchableObject.getDataValueId()));
                        continue block9;
                    }
                    case Float: {
                        watchableObject.setObject(Float.valueOf(nbt.func_74760_g("dataWatcherExObject" + watchableObject.getDataValueId())));
                        continue block9;
                    }
                    case Integer: {
                        watchableObject.setObject(nbt.func_74762_e("dataWatcherExObject" + watchableObject.getDataValueId()));
                        continue block9;
                    }
                    case Short: {
                        watchableObject.setObject(nbt.func_74765_d("dataWatcherExObject" + watchableObject.getDataValueId()));
                        continue block9;
                    }
                    case String: {
                        watchableObject.setObject(nbt.func_74779_i("dataWatcherExObject" + watchableObject.getDataValueId()));
                        continue block9;
                    }
                }
                RadixExcept.logErrorCatch(new Throwable(), "Error reading watched object " + watchableObject.getDataValueId() + " from NBT. Invalid data type.");
            }
        }
        catch (Exception e) {
            RadixExcept.logErrorCatch(e, "Error saving data watcher to NBT.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setObjectOwner(Object obj) {
        this.objectOwner = obj;
    }

    static {
        dataTypes.put(Byte.class, 0);
        dataTypes.put(Short.class, 1);
        dataTypes.put(Integer.class, 2);
        dataTypes.put(Float.class, 3);
        dataTypes.put(String.class, 4);
    }
}

