/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.zip.Inflater;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.FriendlyByteBuf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CompressionDecoder.class}, priority=99)
public abstract class NettyCompressionDecoderMixin
extends ByteToMessageDecoder {
    @Shadow
    private int f_129435_;
    @Shadow
    @Final
    private Inflater f_129434_;

    @Overwrite
    public void decode(ChannelHandlerContext context, ByteBuf byteBuf, List<Object> decoded) throws Exception {
        if (byteBuf.readableBytes() != 0) {
            FriendlyByteBuf packetbuffer = new FriendlyByteBuf(byteBuf);
            int i = packetbuffer.m_130242_();
            if (i == 0) {
                decoded.add(packetbuffer.readBytes(packetbuffer.readableBytes()));
            } else {
                byte[] abyte = new byte[packetbuffer.readableBytes()];
                packetbuffer.readBytes(abyte);
                this.f_129434_.setInput(abyte);
                byte[] abyte1 = new byte[i];
                this.f_129434_.inflate(abyte1);
                decoded.add(Unpooled.wrappedBuffer((byte[])abyte1));
                this.f_129434_.reset();
                if (i < this.f_129435_) {
                    this.printDebug(decoded);
                    if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
                        throw new DecoderException("Badly compressed packet - size of " + i + " is below server threshold of " + this.f_129435_);
                    }
                }
                if (i > 0x800000) {
                    this.printDebug(decoded);
                    if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).disablePacketLimits) {
                        throw new DecoderException("Badly compressed packet - size of " + i + " is larger than protocol maximum of 8388608");
                    }
                }
            }
        }
    }

    private void printDebug(List<Object> decodingResults) {
        if (!((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
            return;
        }
        Connectivity.LOGGER.error("Received too large message, debug print below!");
        Connectivity.LOGGER.error("----BEGIND PRINTING PACKET-----");
        for (int i = 0; i < decodingResults.size(); ++i) {
            ByteBuf buf = (ByteBuf)decodingResults.get(i);
            if (buf == null) continue;
            Connectivity.LOGGER.error("Data:");
            Connectivity.LOGGER.error(buf.toString(Charsets.UTF_8));
        }
        Connectivity.LOGGER.error("----END PRINTING PACKET-----");
    }
}

