/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkEvent;

public class PacketModuleUpdate {
    private final BlockPos pos;
    private final int slotIndex;
    private final CompoundTag tagCompound;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.slotIndex);
        FriendlyByteBuf buffer = new FriendlyByteBuf((ByteBuf)buf);
        buffer.m_130079_(this.tagCompound);
    }

    public PacketModuleUpdate(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.slotIndex = buf.readInt();
        FriendlyByteBuf buffer = new FriendlyByteBuf((ByteBuf)buf);
        this.tagCompound = buffer.m_130260_();
    }

    public PacketModuleUpdate(BlockPos pos, int slotIndex, CompoundTag tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            Level world = player.m_20193_();
            if (world.m_46805_(this.pos)) {
                double dist = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 3.0;
                if (player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) >= dist * dist) {
                    return;
                }
                BlockEntity patt1919$temp = world.m_7702_(this.pos);
                if (patt1919$temp instanceof ScreenTileEntity) {
                    ScreenTileEntity screen = (ScreenTileEntity)patt1919$temp;
                    screen.updateModuleData(this.slotIndex, this.tagCompound);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

