/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class MoveTool
extends BuildingToolMode.ForCorners {
    public MoveTool(String name, int modelIndex, boolean resetPosesAfterAction) {
        super(name, modelIndex, resetPosesAfterAction);
    }

    @Override
    public boolean targetsSpecificPos() {
        return false;
    }

    @Override
    public int getSpamDelay() {
        return 3;
    }

    @Override
    protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
        if (level.f_46443_) {
            return;
        }
        int dist = BuildingToolItem.getProperty(stack, ToolModeProperty.MOVE_DISTANCE);
        boolean cut = BuildingToolItem.getProperty(stack, ToolModeProperty.CUT_TRUE).value();
        ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_ALL_AIR);
        Direction facing = Direction.m_122382_((Entity)player)[0];
        if (player.m_6144_()) {
            facing = facing.m_122424_();
        }
        CapturedBlocks captured = new CapturedBlocks(level, cornerA, cornerB);
        ActionHistory.ActionBuilder action = ActionHistory.newAction();
        BlockState air = Blocks.f_50016_.m_49966_();
        if (cut) {
            this.forPosesWithin((Vec3i)cornerA, (Vec3i)cornerB, pos -> this.setBlock(level, (BlockPos)pos, air, action));
        }
        int total = 0;
        BlockPos placePos = captured.getWorldPos();
        for (CapturedBlocks.BlockInfo info : captured.getBlockInfos()) {
            BlockPos placeAt = placePos.m_121955_((Vec3i)info.pos()).m_5484_(facing, dist);
            if (!replace.shouldReplace(level, air, placeAt) || !this.setBlock(level, placeAt, old -> info.state(), info.blockEntityTag().orElse(null), action, captured.getMirror(), captured.getRotation())) continue;
            ++total;
        }
        action.changeSelection(this, 0, cornerA, cornerA.m_5484_(facing, dist));
        BuildingToolItem.setPos(stack, 0, (Vec3i)cornerA.m_5484_(facing, dist));
        action.changeSelection(this, 1, cornerB, cornerB.m_5484_(facing, dist));
        BuildingToolItem.setPos(stack, 1, (Vec3i)cornerB.m_5484_(facing, dist));
        ActionHistory.get(player).add(level, action);
        BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.move_blocks", total, facing.m_7912_());
        BuildingToolMode.playSound(player, SoundEvents.f_12312_);
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String shift = SGText.keybindString(options.f_92090_);
        String rightClick = SGText.keybindString(options.f_92095_);
        String leftClick = SGText.keybindString(options.f_92096_);
        return new Object[]{Component.m_237110_((String)"item.structure_gel.building_tool.mode.select_corners", (Object[])new Object[]{rightClick, shift, rightClick, rightClick, shift}), leftClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.MOVE_DISTANCE);
        properties.add(ToolModeProperty.CUT_TRUE);
        properties.add(ToolModeProperty.REPLACE_ALL_AIR);
    }

    @Override
    public boolean hasBlockPalette() {
        return false;
    }
}

