/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.recipe.AbstractOneToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class OneToOneRecipeSerializer<Ingredient, Result, RecipeIngredient extends IRecipeIngredient<Ingredient>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractOneToOneRecipe<Ingredient, Result, RecipeIngredient, RecipeResult>>
implements RecipeSerializer<Recipe> {
    private final AbstractOneToOneRecipe.IRecipeFactory<Ingredient, Result, RecipeIngredient, RecipeResult, Recipe> _recipeFactory;
    private final Function<JsonElement, RecipeIngredient> _jsonIngredientFactory;
    private final Function<FriendlyByteBuf, RecipeIngredient> _packetIngredientFactory;
    private final Function<JsonElement, RecipeResult> _jsonResultFactory;
    private final Function<FriendlyByteBuf, RecipeResult> _packetResultFactory;

    public OneToOneRecipeSerializer(AbstractOneToOneRecipe.IRecipeFactory<Ingredient, Result, RecipeIngredient, RecipeResult, Recipe> recipeFactory, Function<JsonElement, RecipeIngredient> jsonIngredientFactory, Function<FriendlyByteBuf, RecipeIngredient> packetIngredientFactory, Function<JsonElement, RecipeResult> jsonResultFactory, Function<FriendlyByteBuf, RecipeResult> packetResultFactory) {
        this._recipeFactory = recipeFactory;
        this._jsonIngredientFactory = jsonIngredientFactory;
        this._packetIngredientFactory = packetIngredientFactory;
        this._jsonResultFactory = jsonResultFactory;
        this._packetResultFactory = packetResultFactory;
    }

    public Recipe fromJson(ResourceLocation recipeId, JsonObject json) {
        IRecipeIngredient ingredient = (IRecipeIngredient)this._jsonIngredientFactory.apply(JSONHelper.jsonGetMandatoryElement(json, "ingredient"));
        IRecipeResult result = (IRecipeResult)this._jsonResultFactory.apply(JSONHelper.jsonGetMandatoryElement(json, "result"));
        return this.create(recipeId, ingredient, result);
    }

    @Nullable
    public Recipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        IRecipeIngredient ingredient = (IRecipeIngredient)this._packetIngredientFactory.apply(buffer);
        IRecipeResult result = (IRecipeResult)this._packetResultFactory.apply(buffer);
        return this.create(recipeId, ingredient, result);
    }

    public void toNetwork(FriendlyByteBuf buffer, Recipe recipe) {
        ((AbstractOneToOneRecipe)recipe).getIngredient().serializeTo(buffer);
        ((AbstractOneToOneRecipe)recipe).getResult().serializeTo(buffer);
    }

    private Recipe create(ResourceLocation id, RecipeIngredient ingredient, RecipeResult result) {
        if (result.isEmpty()) {
            throw new IllegalArgumentException("A one-to-one recipe result cannot be empty");
        }
        return this._recipeFactory.create(id, ingredient, result);
    }
}

