/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.fluid;

import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AbstractStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class FluidTank
extends AbstractStackHolder<FluidTank, FluidStack>
implements IFluidHandler,
IFluidTank,
ISyncableEntity,
IDebuggable {
    protected FluidStack _content = FluidStack.EMPTY;
    protected int _capacity;

    public FluidTank(int capacity) {
        this._capacity = capacity;
    }

    public FluidTank(int capacity, BiPredicate<Integer, FluidStack> stackValidator) {
        super(stackValidator);
        this._capacity = capacity;
    }

    public void setContent(FluidStack stack) {
        boolean wasEmpty = this.isEmpty(0);
        boolean isNowEmpty = stack.isEmpty();
        if (wasEmpty && isNowEmpty) {
            return;
        }
        this._content = stack;
        this.onChange(wasEmpty ? IStackHolder.ChangeType.Added : (isNowEmpty ? IStackHolder.ChangeType.Removed : IStackHolder.ChangeType.Replaced), 0);
    }

    public FluidTank setCapacity(int capacity) {
        this._capacity = Math.max(0, capacity);
        if (this._content.getAmount() > capacity) {
            this.setContent(new FluidStack(this._content, capacity));
        }
        return this;
    }

    public double getFluidAmountPercentage() {
        return (double)this.getFluidAmount() / (double)this.getCapacity();
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty();
    }

    public int getFreeSpace() {
        return Math.max(0, this._capacity - this.getFluidAmount());
    }

    @Nonnull
    public FluidStack getFluid() {
        return this._content;
    }

    public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    public int getCapacity() {
        return this._capacity;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.isStackValid(0, stack);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this._content.isEmpty()) {
                return Math.min(this._capacity, resource.getAmount());
            }
            if (!this._content.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getFreeSpace(), resource.getAmount());
        }
        if (this._content.isEmpty()) {
            this._content = new FluidStack(resource, Math.min(this._capacity, resource.getAmount()));
            this.onChange(IStackHolder.ChangeType.Added, 0);
            return this._content.getAmount();
        }
        if (!this._content.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this._capacity - this._content.getAmount();
        if (resource.getAmount() < filled) {
            this._content.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this._content.setAmount(this._capacity);
        }
        if (filled > 0) {
            this.onChange(IStackHolder.ChangeType.Grown, 0);
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this._content)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = Math.min(this._content.getAmount(), maxDrain);
        FluidStack stack = new FluidStack(this._content, drained);
        if (action.execute() && drained > 0) {
            this._content.shrink(drained);
            this.onChange(IStackHolder.ChangeType.Shrunk, 0);
        }
        return stack;
    }

    @Override
    public boolean isEmpty(int index) {
        return this.getFluid().isEmpty();
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (data.m_128441_("capacity")) {
            this.setCapacity(data.m_128451_("capacity"));
        }
        if (data.m_128441_("content")) {
            this.setContent(FluidHelper.stackFrom(data.m_128469_("content")));
        }
        this.onLoad();
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        data.m_128405_("capacity", this.getCapacity());
        data.m_128365_("content", (Tag)FluidHelper.stackToNBT(this.getFluid()));
        return data;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Capacity: %d", this.getCapacity());
        messages.addUnlocalized(FluidHelper.toStringHelper(this._content));
    }
}

