/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.nbt;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.zerono.mods.zerocore.lib.item.inventory.ItemStackHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.ItemStackHandler;

public interface ISyncableEntity {
    default public void syncDataFrom(CompoundTag data, SyncReason syncReason) {
    }

    default public CompoundTag syncDataTo(CompoundTag data, SyncReason syncReason) {
        return data;
    }

    default public boolean syncChildDataEntityFrom(ISyncableEntity childEntity, String dataKey, CompoundTag parentData, SyncReason syncReason) {
        if (parentData.m_128441_(dataKey)) {
            childEntity.syncDataFrom(parentData.m_128469_(dataKey), syncReason);
            return true;
        }
        return false;
    }

    default public void syncChildDataEntityTo(ISyncableEntity childEntity, String dataKey, CompoundTag parentData, SyncReason syncReason) {
        parentData.m_128365_(dataKey, (Tag)childEntity.syncDataTo(new CompoundTag(), syncReason));
    }

    default public void syncDataElementFrom(String dataKey, CompoundTag parentData, NonNullConsumer<CompoundTag> consumer) {
        if (parentData.m_128441_(dataKey)) {
            consumer.accept((Object)parentData.m_128469_(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundTag parentData, CompoundTag value) {
        parentData.m_128365_(dataKey, (Tag)value);
    }

    default public void syncDataElementFrom(String dataKey, CompoundTag parentData, ItemStackHandler value) {
        if (parentData.m_128441_(dataKey)) {
            value.deserializeNBT(parentData.m_128469_(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundTag parentData, ItemStackHandler value) {
        parentData.m_128365_(dataKey, (Tag)value.serializeNBT());
    }

    default public void syncDataElementFrom(String dataKey, CompoundTag parentData, ItemStackHolder value) {
        if (parentData.m_128441_(dataKey)) {
            value.deserializeNBT(parentData.m_128469_(dataKey));
        }
    }

    default public void syncDataElementTo(String dataKey, CompoundTag parentData, ItemStackHolder value) {
        parentData.m_128365_(dataKey, (Tag)value.serializeNBT());
    }

    default public void syncBooleanElementFrom(String dataKey, CompoundTag parentData, BooleanConsumer consumer) {
        if (parentData.m_128441_(dataKey)) {
            consumer.accept(parentData.m_128471_(dataKey));
        }
    }

    default public void syncBooleanElementTo(String dataKey, CompoundTag parentData, boolean value) {
        parentData.m_128379_(dataKey, value);
    }

    public static enum SyncReason {
        FullSync,
        NetworkUpdate;


        public boolean isFullSync() {
            return this == FullSync;
        }

        public boolean isNetworkUpdate() {
            return this == NetworkUpdate;
        }
    }
}

