/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractGaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class GaugeBar
extends AbstractGaugeBar {
    private double _value = 0.0;
    @Nonnull
    private ISprite _barSprite;
    private Colour _barSpriteTint;

    public GaugeBar(ModContainerScreen<? extends ModContainer> gui, String name, double maxValue, ISprite barSprite) {
        super(gui, name, maxValue);
        this._barSprite = (ISprite)Preconditions.checkNotNull((Object)barSprite);
        this._barSpriteTint = Colour.WHITE;
    }

    public double getValue() {
        return this._value;
    }

    public void setValue(double value) {
        this._value = Mth.m_14008_((double)value, (double)0.0, (double)this.getMaxValue());
    }

    public void setBarSprite(ISprite barSprite) {
        this._barSprite = (ISprite)Preconditions.checkNotNull((Object)barSprite);
    }

    public void setBarSpriteTint(Colour tint) {
        this._barSpriteTint = tint;
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.onPaint(gfx, partialTicks, mouseX, mouseY);
        Rectangle area = this.getPaddingRect();
        ModRenderHelper.paintOrientedProgressBarSprite(gfx, this.getOrientation(), this._barSprite, this.controlToScreen(area.Origin.X, area.Origin.Y), (int)this.getZLevel(), area, this.getFillRatio(), this._barSpriteTint);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" value:").append(this._value);
    }

    protected double getFillRatio() {
        return this.getValue() / this.getMaxValue();
    }
}

