/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.network.AbstractModTileMessage;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;

public class TileCommandMessage
extends AbstractModTileMessage {
    private final String _name;
    private final CompoundTag _parameters;

    public static TileCommandMessage create(AbstractModBlockEntity tile, String commandName) {
        return TileCommandMessage.create(tile, commandName, NBTHelper.EMPTY_COMPOUND);
    }

    public static TileCommandMessage create(AbstractModBlockEntity tile, String commandName, CompoundTag parameters) {
        return new TileCommandMessage(tile, commandName, parameters);
    }

    public TileCommandMessage(FriendlyByteBuf buffer) {
        super(buffer);
        this._name = buffer.m_130136_(4096);
        this._parameters = buffer.readBoolean() ? buffer.m_130260_() : NBTHelper.EMPTY_COMPOUND;
    }

    @Override
    public void encodeTo(FriendlyByteBuf buffer) {
        super.encodeTo(buffer);
        buffer.m_130070_(this._name);
        if (this._parameters.m_128456_()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130079_(this._parameters);
        }
    }

    @Override
    protected void processTileEntityMessage(LogicalSide sourceSide, BlockEntity tileEntity) {
        if (tileEntity instanceof AbstractModBlockEntity) {
            ((AbstractModBlockEntity)tileEntity).handleCommand(sourceSide, this._name, this._parameters);
        } else {
            Log.LOGGER.error(Log.NETWORK, "No command-aware Tile Entity found while processing a command message: skipping");
        }
    }

    protected TileCommandMessage(AbstractModBlockEntity tile, String commandName, CompoundTag parameters) {
        super(tile.m_58899_(), (ResourceKey<Level>)Objects.requireNonNull(tile.m_58904_()).m_46472_());
        this._name = commandName;
        this._parameters = parameters;
    }
}

