/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads.config;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.gui.registry.api.GuiProvider;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.minecraft.network.chat.Component;

public class AliasesGuiProvider
implements GuiProvider {
    public static final Pattern PATTERN = Pattern.compile("\\s*(.+)\\s+->\\s+(\\S+)\\s*");

    public static Map<String, String> toAliases(List<String> aliasStrings) {
        LinkedHashMap<String, String> aliases = new LinkedHashMap<String, String>();
        for (String s : aliasStrings) {
            Matcher matcher = PATTERN.matcher(s);
            if (matcher.matches()) {
                String[] nicknames = matcher.group(1).split("\\s+");
                String profileName = matcher.group(2);
                for (String nick : nicknames) {
                    aliases.put(nick, profileName);
                }
                continue;
            }
            throw new IllegalArgumentException();
        }
        return aliases;
    }

    public static List<String> toStrings(Map<String, String> aliases) {
        LinkedHashMap<String, Set> reverse = new LinkedHashMap<String, Set>();
        for (Map.Entry<String, String> entry2 : aliases.entrySet()) {
            String nickname = entry2.getKey();
            String profileName = entry2.getValue();
            reverse.compute(profileName, (k, v) -> {
                if (v == null) {
                    v = new LinkedHashSet<String>();
                }
                v.add(nickname);
                return v;
            });
        }
        return reverse.entrySet().stream().map(entry -> {
            String profilename = (String)entry.getKey();
            String nicks = (String)((Set)entry.getValue()).stream().reduce((a, b) -> a + " " + b).get();
            return nicks + " -> " + profilename;
        }).collect(Collectors.toList());
    }

    public List<AbstractConfigListEntry> get(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        return Collections.singletonList(ConfigEntryBuilder.create().startStrList((Component)Component.m_237115_((String)i13n), AliasesGuiProvider.toStrings((Map)Utils.getUnsafely((Field)field, (Object)config))).setExpanded(true).setCreateNewInstance(entry -> new StringListListEntry.StringListCell("   ->   ", entry)).setDefaultValue(() -> AliasesGuiProvider.toStrings((Map)Utils.getUnsafely((Field)field, (Object)defaults))).setErrorSupplier(newValue -> {
            try {
                AliasesGuiProvider.toAliases(newValue);
                return Optional.empty();
            }
            catch (Exception e) {
                return Optional.of(Component.m_237119_());
            }
        }).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, AliasesGuiProvider.toAliases(newValue))).build());
    }
}

