/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import com.mojang.blaze3d.platform.NativeImage;
import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.config.SenderDetection;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ChatTypeDecoration;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static final String NON_NAME_REGEX = "(\u00a7.)|[^\\w]";
    public static final ResourceLocation DISABLE_RESOURCE = new ResourceLocation("chat_heads", "disable");
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static PlayerInfo lastSender;
    public static boolean refreshing;
    @Nullable
    public static PlayerInfo lineOwner;
    @Nullable
    public static PlayerInfo refreshingLineOwner;
    @Nullable
    public static GuiMessage.Line lastGuiMessage;
    public static int lastY;
    public static float lastOpacity;
    public static int lastChatOffset;
    public static volatile boolean serverSentUuid;
    public static volatile boolean serverDisabledChatHeads;
    public static final Set<ResourceLocation> blendedHeadTextures;

    public static PlayerInfo getLineOwner() {
        return refreshing ? refreshingLineOwner : lineOwner;
    }

    public static void resetLineOwner() {
        if (refreshing) {
            refreshingLineOwner = null;
        } else {
            lineOwner = null;
        }
    }

    public static void handleAddedMessage(Component message, @Nullable ChatType.Bound bound, @Nullable PlayerInfo playerInfo) {
        if (serverDisabledChatHeads) {
            lastSender = null;
            return;
        }
        if (CONFIG.senderDetection() != SenderDetection.HEURISTIC_ONLY) {
            if (playerInfo != null) {
                lastSender = playerInfo;
                serverSentUuid = true;
                return;
            }
            if (CONFIG.senderDetection() == SenderDetection.UUID_ONLY || serverSentUuid && CONFIG.smartHeuristics()) {
                lastSender = null;
                return;
            }
        }
        lastSender = ChatHeads.detectPlayer(message, bound);
    }

    public static int getChatOffset(@NotNull GuiMessage.Line guiMessage) {
        PlayerInfo owner = ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
        return ChatHeads.getChatOffset(owner);
    }

    public static int getChatOffset(@Nullable PlayerInfo owner) {
        if (owner != null || CONFIG.offsetNonPlayerText() && !serverDisabledChatHeads) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static PlayerInfo detectPlayer(Component message, @Nullable ChatType.Bound bound) {
        PlayerInfo player;
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection == null) {
            return null;
        }
        HashMap<String, PlayerInfo> profileNameCache = new HashMap<String, PlayerInfo>();
        HashMap<String, PlayerInfo> nicknameCache = new HashMap<String, PlayerInfo>();
        Component sender = ChatHeads.getSenderDecoration(bound);
        if (sender != null) {
            PlayerInfo player2;
            Optional<String> tellReceiver = ChatHeads.getTellReceiver(sender);
            if (tellReceiver.isPresent() && (player2 = ChatHeads.getPlayerInfo(tellReceiver.get(), connection, profileNameCache, nicknameCache)) != null) {
                return player2;
            }
            String cleanSender = sender.getString().replaceAll(NON_NAME_REGEX, "");
            return ChatHeads.getPlayerInfo(cleanSender, connection, profileNameCache, nicknameCache);
        }
        Optional<String> tellReceiver = ChatHeads.getTellReceiver(message);
        if (tellReceiver.isPresent() && (player = ChatHeads.getPlayerInfo(tellReceiver.get(), connection, profileNameCache, nicknameCache)) != null) {
            return player;
        }
        for (String word : message.getString().split(NON_NAME_REGEX)) {
            PlayerInfo player3;
            if (word.isEmpty() || (player3 = ChatHeads.getPlayerInfo(word, connection, profileNameCache, nicknameCache)) == null) continue;
            return player3;
        }
        return null;
    }

    private static Optional<String> getTellReceiver(Component component) {
        return component.m_7451_((style, string) -> {
            String cmd;
            ClickEvent clickEvent = style.m_131182_();
            if (clickEvent != null && (cmd = clickEvent.m_130623_()).startsWith("/tell ")) {
                String name = cmd.substring("/tell ".length());
                return Optional.of(name.replaceAll(NON_NAME_REGEX, ""));
            }
            return Optional.empty();
        }, Style.f_131099_);
    }

    @Nullable
    private static Component getSenderDecoration(@Nullable ChatType.Bound bound) {
        if (bound == null) {
            return null;
        }
        for (ChatTypeDecoration.Parameter param : bound.f_240859_().f_237011_().f_238656_()) {
            if (param != ChatTypeDecoration.Parameter.SENDER) continue;
            return bound.f_240886_();
        }
        return null;
    }

    @Nullable
    private static PlayerInfo getPlayerInfo(@NotNull String name, ClientPacketListener connection, Map<String, PlayerInfo> profileNameCache, Map<String, PlayerInfo> nicknameCache) {
        PlayerInfo player = ChatHeads.getPlayerFromProfileName(name = CONFIG.getProfileName(name).replaceAll(NON_NAME_REGEX, ""), connection, profileNameCache);
        if (player != null) {
            return player;
        }
        return ChatHeads.getPlayerFromNickname(name, connection, nicknameCache);
    }

    public static <V, K> V findByKey(Iterable<V> collection, Function<V, K> keyFunction, K key, @Nullable Map<K, V> cache) {
        if (cache != null && !cache.isEmpty()) {
            return cache.get(key);
        }
        for (V v : collection) {
            K k = keyFunction.apply(v);
            if (k == null) continue;
            if (key.equals(k)) {
                if (cache != null) {
                    cache.clear();
                }
                return v;
            }
            if (cache == null) continue;
            cache.put(k, v);
        }
        return null;
    }

    @Nullable
    public static PlayerInfo getPlayerFromProfileName(@NotNull String word, ClientPacketListener connection, Map<String, PlayerInfo> profileNameCache) {
        return ChatHeads.findByKey(connection.m_105142_(), playerInfo -> playerInfo.m_105312_().getName().replaceAll(NON_NAME_REGEX, ""), word, profileNameCache);
    }

    @Nullable
    private static PlayerInfo getPlayerFromNickname(@NotNull String word, ClientPacketListener connection, Map<String, PlayerInfo> nicknameCache) {
        return ChatHeads.findByKey(connection.m_105142_(), playerInfo -> {
            Component displayName = playerInfo.m_105342_();
            return displayName != null ? displayName.getString().replaceAll(NON_NAME_REGEX, "") : null;
        }, word, nicknameCache);
    }

    public static NativeImage extractBlendedHead(NativeImage skin) {
        int xScale = skin.m_84982_() / 64;
        int yScale = skin.m_85084_() / 64;
        NativeImage head = new NativeImage(8 * xScale, 8 * yScale, false);
        for (int y = 0; y < head.m_85084_(); ++y) {
            for (int x = 0; x < head.m_84982_(); ++x) {
                int headColor = skin.m_84985_(8 * xScale + x, 8 * yScale + y);
                int hatColor = skin.m_84985_(40 * xScale + x, 8 * yScale + y);
                head.m_84988_(x, y, headColor);
                head.m_166411_(x, y, hatColor);
            }
        }
        return head;
    }

    public static ResourceLocation getBlendedHeadLocation(ResourceLocation skinLocation) {
        return new ResourceLocation(MOD_ID, skinLocation.m_135815_());
    }

    public static void renderChatHead(GuiGraphics guiGraphics, int x, int y, PlayerInfo owner) {
        ResourceLocation skinLocation = owner.m_105337_();
        if (blendedHeadTextures.contains(skinLocation)) {
            guiGraphics.m_280411_(ChatHeads.getBlendedHeadLocation(skinLocation), x, y, 8, 8, 0.0f, 0.0f, 8, 8, 8, 8);
        } else {
            guiGraphics.m_280411_(skinLocation, x, y, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280411_(skinLocation, x, y, 8, 8, 40.0f, 8.0f, 8, 8, 64, 64);
        }
    }

    static {
        lastY = 0;
        lastOpacity = 0.0f;
        serverSentUuid = false;
        serverDisabledChatHeads = false;
        blendedHeadTextures = new HashSet<ResourceLocation>();
    }
}

