/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ScreenKeyEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ModKeyMappings;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;

public class InventoryEssentialsClient {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static Slot lastDragHoverSlot;

    public static void initialize() {
        ModKeyMappings.initialize(BalmClient.getKeyMappings());
        Balm.getEvents().onEvent(ScreenMouseEvent.Drag.Pre.class, InventoryEssentialsClient::onMouseDrag);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, InventoryEssentialsClient::onMouseClick);
        Balm.getEvents().onEvent(ScreenKeyEvent.Press.Pre.class, InventoryEssentialsClient::onKeyPress);
    }

    private static InventoryControls getInventoryControls() {
        return InventoryEssentials.isServerSideInstalled && !InventoryEssentialsConfig.getActive().forceClientImplementation ? serverSupportedControls : clientOnlyControls;
    }

    public static void onMouseDrag(ScreenMouseEvent.Drag.Pre event) {
        if (BalmClient.getKeyMappings().isActiveAndKeyDown(ModKeyMappings.keyDragTransfer)) {
            InventoryControls controls = InventoryEssentialsClient.getInventoryControls();
            Screen screen = event.getScreen();
            if (screen instanceof AbstractContainerScreen) {
                CreativeModeInventoryScreenAccessor accessor;
                AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                Slot hoverSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
                if (hoverSlot == null || !InventoryEssentialsClient.shouldHandleSlot(hoverSlot)) {
                    return;
                }
                if (hoverSlot instanceof ResultSlot) {
                    return;
                }
                Screen screen3 = event.getScreen();
                if (screen3 instanceof CreativeModeInventoryScreenAccessor && hoverSlot.f_40218_ == (accessor = (CreativeModeInventoryScreenAccessor)screen3).getCONTAINER()) {
                    return;
                }
                if (hoverSlot.m_6657_() && hoverSlot != lastDragHoverSlot) {
                    controls.dragTransfer(screen2, hoverSlot);
                    lastDragHoverSlot = hoverSlot;
                }
            }
        } else {
            lastDragHoverSlot = null;
        }
    }

    private static boolean shouldHandleSlot(Slot slot) {
        return slot.f_40218_ != null && slot.f_40218_.m_6643_() != 0;
    }

    public static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        if (InventoryEssentialsClient.onInput(event.getScreen(), InputConstants.Type.MOUSE.m_84895_(event.getButton()), event.getMouseX(), event.getMouseY())) {
            event.setCanceled(true);
        }
    }

    public static void onKeyPress(ScreenKeyEvent.Press.Pre event) {
        if (InventoryEssentialsClient.onInput(event.getScreen(), InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode()), 0.0, 0.0)) {
            event.setCanceled(true);
        }
    }

    public static boolean onInput(Screen screen, InputConstants.Key key, double mouseX, double mouseY) {
        InventoryControls controls = InventoryEssentialsClient.getInventoryControls();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)containerScreen;
            Slot hoverSlot = accessor.getHoveredSlot();
            if (hoverSlot instanceof ResultSlot) {
                return false;
            }
            if (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkTransfer, key) ? hoverSlot != null && controls.bulkTransferByType(containerScreen, hoverSlot) : (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keySingleTransfer, key) ? hoverSlot != null && controls.singleTransfer(containerScreen, hoverSlot) : (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkTransferAll, key) ? hoverSlot != null && controls.bulkTransferAll(containerScreen, hoverSlot) : (BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyScreenBulkDrop, key) ? accessor.callHasClickedOutside(mouseX, mouseY, accessor.getLeftPos(), accessor.getTopPos(), key.m_84873_()) && controls.dropByType(containerScreen, containerScreen.m_6262_().m_142621_()) : BalmClient.getKeyMappings().isActiveAndMatches(ModKeyMappings.keyBulkDrop, key) && hoverSlot != null && controls.dropByType(containerScreen, hoverSlot))))) {
                return true;
            }
        }
        return false;
    }
}

