/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class RecipeBroomPartCombination
extends CustomRecipe {
    public RecipeBroomPartCombination(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer grid, Level world) {
        return !this.assemble(grid, world.m_9598_()).m_41619_();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return new ItemStack((ItemLike)RegistryEntries.ITEM_BROOM);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList aitemstack = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            aitemstack.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inventory);
        if (result != null) {
            List extraOutputs = (List)result.getRight();
            for (ItemStack extraOutput : extraOutputs) {
                InventoryHelpers.tryReAddToStack((Player)ForgeHooks.getCraftingPlayer(), (ItemStack)ItemStack.f_41583_, (ItemStack)extraOutput, (InteractionHand)ForgeHooks.getCraftingPlayer().m_7655_());
            }
        }
        return aitemstack;
    }

    protected Map<IBroomPart.BroomPartType, IBroomPart> indexifyParts(Collection<IBroomPart> parts) {
        HashMap map = Maps.newHashMap();
        for (IBroomPart part : parts) {
            if (part.getType() == IBroomPart.BroomPartType.MODIFIER) continue;
            map.put(part.getType(), part);
        }
        return map;
    }

    protected Pair<ItemStack, List<ItemStack>> getResult(CraftingContainer grid) {
        ItemStack element;
        int j;
        ItemStack output = this.getResultItem().m_41777_();
        LinkedList extraOutputs = Lists.newLinkedList();
        int existingBroomSlot = -1;
        Map<IBroomPart.BroomPartType, IBroomPart> existingBroomParts = null;
        HashMap parts = Maps.newHashMap();
        LinkedList rawModifiers = Lists.newLinkedList();
        for (j = 0; j < grid.m_6643_(); ++j) {
            Map<IBroomPart.BroomPartType, IBroomPart> currentExistingBroomParts;
            element = grid.m_8020_(j);
            if (element.m_41619_() || !(element.m_41720_() instanceof IBroom) || (currentExistingBroomParts = this.indexifyParts(BroomParts.REGISTRY.getBroomParts(element))) == null || !this.areValidBroomParts(currentExistingBroomParts.values()) || element.m_41613_() != 1) continue;
            if (existingBroomParts == null) {
                existingBroomParts = currentExistingBroomParts;
                output = element.m_41777_();
                existingBroomSlot = j;
                continue;
            }
            return null;
        }
        for (j = 0; j < grid.m_6643_(); ++j) {
            element = grid.m_8020_(j);
            if (element.m_41619_()) continue;
            Object part = BroomParts.REGISTRY.getPartFromItem(element);
            Map<BroomModifier, Float> modifier = BroomModifiers.REGISTRY.getModifiersFromItem(element);
            if (part != null) {
                if (parts.containsKey(part.getType())) {
                    return null;
                }
                parts.put(part.getType(), part);
                continue;
            }
            if (modifier != null) {
                rawModifiers.add(modifier);
                continue;
            }
            if (j == existingBroomSlot) continue;
            return null;
        }
        if (existingBroomParts != null) {
            for (Map.Entry entry : existingBroomParts.entrySet()) {
                if (parts.containsKey(entry.getKey())) {
                    extraOutputs.add(((ItemStack)Iterables.get(BroomParts.REGISTRY.getItemsFromPart((IBroomPart)entry.getValue()), (int)0)).m_41777_());
                    continue;
                }
                parts.put((IBroomPart.BroomPartType)entry.getKey(), (IBroomPart)entry.getValue());
            }
        }
        if (!this.areValidBroomParts(parts.values())) {
            return null;
        }
        BroomParts.REGISTRY.setBroomParts(output, parts.values());
        Map<BroomModifier, Float> broomModifiers = BroomModifiers.REGISTRY.getModifiers(output);
        Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(output);
        this.applyNewModifiers(broomModifiers, rawModifiers);
        if (!this.areValidBroomModifiers(broomModifiers, baseModifiers)) {
            return null;
        }
        BroomModifiers.REGISTRY.setModifiers(output, broomModifiers);
        return Pair.of((Object)output, (Object)extraOutputs);
    }

    private void applyNewModifiers(Map<BroomModifier, Float> baseModifiers, List<Map<BroomModifier, Float>> rawModifiers) {
        for (Map<BroomModifier, Float> modifierValue : rawModifiers) {
            for (Map.Entry<BroomModifier, Float> entry : modifierValue.entrySet()) {
                BroomModifier modifier = entry.getKey();
                Float value = baseModifiers.get(entry.getKey());
                if (value != null) {
                    baseModifiers.put(modifier, Float.valueOf(modifier.apply(value.floatValue(), Lists.newArrayList((Object[])new Float[]{entry.getValue()}))));
                    continue;
                }
                baseModifiers.put(modifier, Float.valueOf(modifier.apply(modifier.getDefaultValue(), Lists.newArrayList((Object[])new Float[]{entry.getValue()}))));
            }
        }
    }

    public ItemStack assemble(CraftingContainer grid, RegistryAccess registryAccess) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(grid);
        if (result == null) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)result.getLeft();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_BROOM_PART_COMBINATION;
    }

    private boolean areValidBroomParts(Collection<IBroomPart> parts) {
        HashSet remainingRequiredTypes = Sets.newHashSet((Object[])IBroomPart.BroomPartType.BASE_TYPES);
        for (IBroomPart part : parts) {
            remainingRequiredTypes.remove(part.getType());
        }
        return remainingRequiredTypes.isEmpty();
    }

    private boolean areValidBroomModifiers(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = (int)Math.ceil(entry.getValue().floatValue() / entry.getKey().getTierValue());
            if (tier > entry.getKey().getMaxTiers()) {
                return false;
            }
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        broomModifiers.put(BroomModifiers.MODIFIER_COUNT, Float.valueOf((float)maxModifiers - (float)baseMaxModifiers));
        return modifiers <= maxModifiers;
    }
}

