/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.inventory.container.ContainerInventoryTickingTank;

public abstract class ContainerScreenContainerTankInventory<C extends ContainerInventoryTickingTank<T>, T extends BlockEntityTickingTankInventory<T>>
extends ContainerScreenExtended<C> {
    private boolean showTank = false;
    private int tankWidth;
    private int tankHeight;
    private int tankX;
    private int tankY;
    private int tankTargetX;
    private int tankTargetY;
    private boolean showProgress = false;
    private int progressWidth;
    private int progressHeight;
    private int progressX;
    private int progressY;
    private int progressTargetX;
    private int progressTargetY;

    public ContainerScreenContainerTankInventory(C container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void setTank(int tankWidth, int tankHeight, int tankX, int tankY, int tankTargetX, int tankTargetY) {
        this.showTank = true;
        this.tankWidth = tankWidth;
        this.tankHeight = tankHeight;
        this.tankX = tankX;
        this.tankY = tankY;
        this.tankTargetX = tankTargetX + this.offsetX;
        this.tankTargetY = tankTargetY + this.offsetY;
    }

    protected void setProgress(int progressWidth, int progressHeight, int progressX, int progressY, int progressTargetX, int progressTargetY) {
        this.showProgress = true;
        this.progressWidth = progressWidth;
        this.progressHeight = progressHeight;
        this.progressX = progressX;
        this.progressY = progressY;
        this.progressTargetX = progressTargetX + this.offsetX;
        this.progressTargetY = progressTargetY + this.offsetY;
    }

    protected boolean isShowProgress() {
        return this.showProgress;
    }

    protected int getProgressXScaled(int width) {
        return width;
    }

    protected int getProgressYScaled(int height) {
        return height;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int x, int y) {
        super.m_7286_(guiGraphics, f, x, y);
        if (this.isShowProgress()) {
            guiGraphics.m_280218_(this.getGuiTexture(), this.f_97735_ + this.progressTargetX, this.f_97736_ + this.progressTargetY, this.progressX, this.progressY, this.getProgressXScaled(this.progressWidth), this.getProgressYScaled(this.progressHeight));
        }
    }

    protected abstract Component getName();

    protected void drawForgegroundString(GuiGraphics guiGraphics) {
        this.f_96547_.m_272077_(this.getName(), (float)(8 + this.offsetX), (float)(4 + this.offsetY), 0x404040, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawForgegroundString(guiGraphics);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidStack fluidStack = ((ContainerInventoryTickingTank)this.m_6262_()).getFluidStack();
        if (this.shouldRenderTank(fluidStack) && ((ContainerInventoryTickingTank)this.m_6262_()).getFluidCapacity() > 0) {
            int tankSize = Math.min(((ContainerInventoryTickingTank)this.m_6262_()).getFluidCapacity(), Math.min(((ContainerInventoryTickingTank)this.m_6262_()).getFluidCapacity(), fluidStack.getAmount()) * this.tankHeight / ((ContainerInventoryTickingTank)this.m_6262_()).getFluidCapacity());
            this.drawTank(guiGraphics, this.tankTargetX, this.tankTargetY, fluidStack.getFluid(), tankSize);
        }
        this.drawAdditionalForeground(guiGraphics, mouseX, mouseY);
        GlStateManager._disableBlend();
    }

    protected void drawAdditionalForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float gameTicks) {
        super.drawCurrentScreen(guiGraphics, mouseX, mouseY, gameTicks);
        this.drawTooltips(guiGraphics, mouseX, mouseY);
    }

    protected boolean shouldRenderTank(FluidStack fluidStack) {
        if (!this.showTank) {
            return false;
        }
        return fluidStack.getAmount() > 0;
    }

    protected void drawTank(GuiGraphics guiGraphics, int xOffset, int yOffset, Fluid fluid, int level) {
        if (fluid != null) {
            FluidStack stack = new FluidStack(fluid, 1);
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)stack, (Direction)Direction.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight = 0;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                guiGraphics.m_280159_(xOffset, yOffset - textureHeight - verticalOffset, 0, this.tankWidth, textureHeight, icon);
                verticalOffset += 16;
            }
            guiGraphics.m_280218_(this.texture, xOffset, yOffset - this.tankHeight, this.tankX, this.tankY, this.tankWidth, this.tankHeight);
        }
    }

    protected void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        FluidStack fluidStack = ((ContainerInventoryTickingTank)this.m_6262_()).getFluidStack();
        if (this.m_6774_(this.tankTargetX, this.tankTargetY - this.tankHeight, this.tankWidth, this.tankHeight, mouseX, mouseY) && this.shouldRenderTank(fluidStack)) {
            Component fluidName = fluidStack.getDisplayName();
            this.drawBarTooltipTank(guiGraphics, fluidName, fluidStack, fluidStack.getAmount(), ((ContainerInventoryTickingTank)this.m_6262_()).getFluidCapacity(), mouseX, mouseY);
        }
    }

    protected void drawBarTooltipTank(GuiGraphics guiGraphics, Component name, FluidStack fluidStack, int amount, int capacity, int x, int y) {
        ArrayList lines = Lists.newArrayList();
        lines.add(name);
        lines.add(DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)capacity));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
        this.drawTooltip(lines, guiGraphics.m_280168_(), x - this.f_97735_, y - this.f_97736_);
        guiGraphics.m_280168_().m_85849_();
    }
}

