/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.HashSet;
import java.util.Stack;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourTransition;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class HeatBehaviourCustomTransition
extends HeatBehaviourTransition {
    static final ResourceLocation ID = PneumaticRegistry.RL("custom_transition");
    private HeatPropertiesRecipe heatEntry;

    @Override
    public HeatBehaviour initialize(IHeatExchangerLogic connectedHeatLogic, Level world, BlockPos pos, Direction direction) {
        super.initialize(connectedHeatLogic, world, pos, direction);
        this.heatEntry = BlockHeatProperties.getInstance().getCustomHeatEntry(world, this.getBlockState());
        return this;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean isApplicable() {
        return super.isApplicable() && this.heatEntry != null && this.heatEntry.getHeatCapacity() > 0;
    }

    @Override
    protected int getMaxExchangedHeat() {
        return this.getHeatEntry().getHeatCapacity();
    }

    @Override
    protected boolean transformBlockHot() {
        BlockState hot = this.getHeatEntry().getTransformHot();
        if (hot != null) {
            if (this.getFluid() != null) {
                this.transformFluidBlocks(hot, this.getHeatEntry().getTransformHotFlowing());
                return true;
            }
            return this.getWorld().m_46597_(this.getPos(), hot);
        }
        return false;
    }

    @Override
    protected boolean transformBlockCold() {
        BlockState cold = this.getHeatEntry().getTransformCold();
        if (cold != null) {
            if (this.getFluid() != null) {
                this.transformFluidBlocks(cold, this.getHeatEntry().getTransformColdFlowing());
                return true;
            }
            return this.getWorld().m_46597_(this.getPos(), cold);
        }
        return false;
    }

    private HeatPropertiesRecipe getHeatEntry() {
        return this.heatEntry;
    }

    private void transformFluidBlocks(BlockState turningBlockSource, BlockState turningBlockFlowing) {
        if (FluidUtils.isSourceFluidBlock(this.getWorld(), this.getPos())) {
            this.getWorld().m_46597_(this.getPos(), turningBlockSource);
            this.onTransition(this.getPos());
        } else {
            if (turningBlockFlowing == null) {
                turningBlockFlowing = Blocks.f_50016_.m_49966_();
            }
            HashSet<BlockPos> traversed = new HashSet<BlockPos>();
            Stack<BlockPos> pending = new Stack<BlockPos>();
            pending.push(this.getPos());
            traversed.add(this.getPos());
            while (!pending.isEmpty()) {
                BlockPos pos = (BlockPos)pending.pop();
                for (Direction d : DirectionUtil.VALUES) {
                    BlockPos newPos = pos.m_121945_(d);
                    Block checkingBlock = this.getWorld().m_8055_(newPos).m_60734_();
                    if (checkingBlock != this.getBlockState().m_60734_() || !traversed.add(newPos)) continue;
                    if (FluidUtils.isSourceFluidBlock(this.getWorld(), newPos)) {
                        this.getWorld().m_46597_(newPos, turningBlockSource);
                        this.onTransition(newPos);
                        return;
                    }
                    this.getWorld().m_46597_(newPos, turningBlockFlowing);
                    this.onTransition(newPos);
                    pending.push(newPos);
                }
            }
        }
    }
}

