/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class HeatExtractionTracker
extends SavedData {
    private static final String DATA_NAME = "PneumaticCraftHeatExtraction";
    private final Map<BlockPos, Double> extracted = new HashMap<BlockPos, Double>();

    private HeatExtractionTracker() {
    }

    private static HeatExtractionTracker load(CompoundTag tag) {
        return new HeatExtractionTracker().readNBT(tag);
    }

    public static HeatExtractionTracker getInstance(Level world) {
        return (HeatExtractionTracker)((ServerLevel)world).m_8895_().m_164861_(HeatExtractionTracker::load, HeatExtractionTracker::new, DATA_NAME);
    }

    public double getHeatExtracted(BlockPos pos) {
        return this.extracted.getOrDefault(pos, 0.0);
    }

    public void extractHeat(BlockPos pos, double heat) {
        double newAmount = this.getHeatExtracted(pos) + heat;
        if (Math.abs(newAmount) < 1.0E-6) {
            this.extracted.remove(pos);
        } else {
            this.extracted.put(pos, newAmount);
        }
        this.m_77762_();
    }

    private HeatExtractionTracker readNBT(CompoundTag nbt) {
        this.extracted.clear();
        ListTag list = nbt.m_128437_("extracted", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag sub = list.m_128728_(i);
            BlockPos pos = new BlockPos(sub.m_128451_("x"), sub.m_128451_("y"), sub.m_128451_("z"));
            this.extracted.put(pos, sub.m_128459_("heat"));
        }
        return this;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        this.extracted.forEach((pos, heat) -> {
            CompoundTag sub = new CompoundTag();
            sub.m_128405_("x", pos.m_123341_());
            sub.m_128405_("y", pos.m_123342_());
            sub.m_128405_("z", pos.m_123343_());
            sub.m_128347_("heat", heat.doubleValue());
            list.add((Object)sub);
        });
        compound.m_128365_("extracted", (Tag)list);
        return compound;
    }
}

