/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class MicromissileEntity
extends ThrowableProjectile {
    private static final double SEEK_RANGE = 24.0;
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> MAX_VEL_SQ = SynchedEntityData.m_135353_(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ACCEL = SynchedEntityData.m_135353_(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TURN_SPEED = SynchedEntityData.m_135353_(MicromissileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Entity targetEntity = null;
    private float maxVelocitySq = 0.5f;
    private float accel = 1.05f;
    private float turnSpeed = 0.1f;
    private float explosionPower = 2.0f;
    private EntityFilter entityFilter;
    private boolean outOfFuel = false;
    private MicromissilesItem.FireMode fireMode = MicromissilesItem.FireMode.SMART;

    public MicromissileEntity(EntityType<MicromissileEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public MicromissileEntity(Level worldIn, LivingEntity thrower, ItemStack iStack) {
        super((EntityType)ModEntityTypes.MICROMISSILE.get(), thrower, worldIn);
        if (iStack.m_41782_()) {
            CompoundTag tag = Objects.requireNonNull(iStack.m_41783_());
            this.entityFilter = EntityFilter.fromString(tag.m_128461_("filter"));
            this.fireMode = MicromissilesItem.FireMode.fromString(tag.m_128461_("fireMode"));
            switch (this.fireMode) {
                case SMART: {
                    this.accel = Math.max(1.02f, 1.0f + tag.m_128457_("topSpeed") / 10.0f);
                    this.maxVelocitySq = (float)Math.pow(0.25 + (double)(tag.m_128457_("topSpeed") * 3.75f), 2.0);
                    this.turnSpeed = 0.4f * tag.m_128457_("turnSpeed");
                    this.explosionPower = Math.max(1.0f, 5.0f * tag.m_128457_("damage"));
                    break;
                }
                case DUMB: {
                    this.accel = 1.5f;
                    this.maxVelocitySq = 6.25f;
                    this.turnSpeed = 0.0f;
                    this.explosionPower = 3.0f;
                }
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_ID, (Object)0);
        this.f_19804_.m_135372_(MAX_VEL_SQ, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135372_(ACCEL, (Object)Float.valueOf(1.05f));
        this.f_19804_.m_135372_(TURN_SPEED, (Object)Float.valueOf(0.4f));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (this.m_20193_().f_46443_) {
            if (key.equals(MAX_VEL_SQ)) {
                this.maxVelocitySq = ((Float)this.f_19804_.m_135370_(MAX_VEL_SQ)).floatValue();
            } else if (key.equals(TARGET_ID)) {
                int id = (Integer)this.f_19804_.m_135370_(TARGET_ID);
                this.targetEntity = id > 0 ? this.m_20193_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ID)).intValue()) : null;
            } else if (key.equals(ACCEL)) {
                this.accel = ((Float)this.f_19804_.m_135370_(ACCEL)).floatValue();
            } else if (key.equals(TURN_SPEED)) {
                this.turnSpeed = ((Float)this.f_19804_.m_135370_(TURN_SPEED)).floatValue();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1) {
            if (this.m_20193_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11932_, SoundSource.PLAYERS, 1.0f, 0.8f, true);
            } else {
                this.f_19804_.m_135381_(MAX_VEL_SQ, (Object)Float.valueOf(this.maxVelocitySq));
                this.f_19804_.m_135381_(ACCEL, (Object)Float.valueOf(this.accel));
                this.f_19804_.m_135381_(TURN_SPEED, (Object)Float.valueOf(this.turnSpeed));
            }
        } else if (this.f_19797_ > (Integer)ConfigHelper.common().micromissiles.lifetime.get()) {
            this.outOfFuel = true;
            if (this.f_19797_ > (Integer)ConfigHelper.common().micromissiles.maxLifetime.get()) {
                this.explode(null);
            }
        }
        if (!this.outOfFuel) {
            double velSq;
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82490_(1.25));
            } else {
                this.m_20256_(this.m_20184_().m_82490_(1.0101010101010102));
            }
            if (!(this.targetEntity != null && this.targetEntity.m_6084_() || this.fireMode != MicromissilesItem.FireMode.SMART || this.m_20193_().f_46443_ || (this.f_19797_ & 3) != 0)) {
                this.targetEntity = this.tryFindNewTarget();
            }
            if (this.targetEntity != null) {
                Vec3 diff = this.targetEntity.m_20182_().m_82520_(0.0, (double)this.targetEntity.m_20192_(), 0.0).m_82546_(this.m_20182_()).m_82541_().m_82490_((double)this.turnSpeed);
                this.m_20256_(this.m_20184_().m_82549_(diff));
            }
            double mul = (velSq = this.m_20184_().m_82556_()) > (double)this.maxVelocitySq ? (double)this.maxVelocitySq / velSq : (double)this.accel;
            this.m_20256_(this.m_20184_().m_82490_(mul));
            if (this.m_20193_().f_46443_ && this.m_20193_().f_46441_.m_188499_()) {
                Vec3 m = this.m_20184_();
                this.m_9236_().m_7106_((ParticleOptions)AirParticleData.DENSE, this.m_20185_(), this.m_20186_(), this.m_20189_(), -m.f_82479_ / 2.0, -m.f_82480_ / 2.0, -m.f_82481_ / 2.0);
            }
        }
    }

    private Entity tryFindNewTarget() {
        AABB aabb = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82400_(24.0);
        List l = this.m_20193_().m_6443_(LivingEntity.class, aabb, EntitySelector.f_20402_);
        l.sort(new TargetSorter());
        Entity tgt = null;
        for (Entity e : l) {
            if (!this.isValidTarget(e) || !(e.m_20280_((Entity)this) < 576.0)) continue;
            ClipContext ctx = new ClipContext(this.m_20182_(), e.m_20182_().m_82520_(0.0, (double)e.m_20192_(), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, e);
            BlockHitResult res = this.m_20193_().m_45547_(ctx);
            if (res.m_6662_() != HitResult.Type.MISS && res.m_6662_() != HitResult.Type.ENTITY) continue;
            tgt = e;
            break;
        }
        this.f_19804_.m_135381_(TARGET_ID, (Object)(tgt == null ? 0 : tgt.m_19879_()));
        return tgt;
    }

    public boolean isValidTarget(Entity e) {
        Entity thrower = this.m_19749_();
        if (thrower != null) {
            Horse h;
            DroneEntity d;
            TamableAnimal t;
            UUID throwerID = thrower.m_20148_();
            if (thrower.equals((Object)e) || e instanceof TamableAnimal && throwerID.equals((t = (TamableAnimal)e).m_21805_()) || e instanceof DroneEntity && throwerID.equals((d = (DroneEntity)e).getOwnerUUID()) || e instanceof Horse && throwerID.equals((h = (Horse)e).m_21805_())) {
                return false;
            }
        }
        if (this.entityFilter != null && !this.entityFilter.test(e)) {
            return false;
        }
        return e instanceof LivingEntity || e instanceof Boat || e instanceof AbstractMinecart;
    }

    protected void m_6532_(HitResult result) {
        if (this.f_19797_ > 5 && !this.m_20193_().f_46443_ && this.m_6084_()) {
            this.explode(result instanceof EntityHitResult ? ((EntityHitResult)result).m_82443_() : null);
        }
    }

    private void explode(Entity e) {
        double z;
        double y;
        double x;
        this.m_146870_();
        Level.ExplosionInteraction mode = (Boolean)ConfigHelper.common().micromissiles.damageTerrain.get() != false ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
        boolean fire = (Boolean)ConfigHelper.common().micromissiles.startFires.get();
        float radius = ((Double)ConfigHelper.common().micromissiles.baseExplosionDamage.get()).floatValue() * this.explosionPower;
        if (e == null) {
            x = this.m_20185_();
            y = this.m_20186_();
            z = this.m_20189_();
        } else {
            x = Mth.m_14139_((double)0.25, (double)e.m_20185_(), (double)this.m_20185_());
            y = Mth.m_14139_((double)0.25, (double)e.m_20186_(), (double)this.m_20186_());
            z = Mth.m_14139_((double)0.25, (double)e.m_20189_(), (double)this.m_20189_());
        }
        this.m_20193_().m_255391_((Entity)this, x, y, z, radius, fire, mode);
    }

    public void m_37251_(Entity entityThrower, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float x = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.m_6686_(x, y, z, velocity, 0.0f);
        this.m_20256_(this.m_20184_().m_82520_(entityThrower.m_20184_().f_82479_, 0.0, entityThrower.m_20184_().f_82481_));
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        double f = Math.sqrt(x * x + y * y + z * z);
        x = x / f * (double)velocity;
        y = y / f * (double)velocity;
        z = z / f * (double)velocity;
        this.m_20334_(x, y, z);
        float f1 = Mth.m_14116_((float)((float)(x * x + z * z)));
        this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.29577951308232));
        this.m_146926_((float)(Mth.m_14136_((double)y, (double)f1) * 57.29577951308232));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected float m_7139_() {
        return this.outOfFuel ? super.m_7139_() : 0.0f;
    }

    public boolean m_20068_() {
        return !this.outOfFuel;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("turnSpeed", this.turnSpeed);
        compound.m_128350_("explosionScaling", this.explosionPower);
        compound.m_128350_("topSpeedSq", this.maxVelocitySq);
        compound.m_128359_("filter", this.entityFilter.toString());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.turnSpeed = compound.m_128457_("turnSpeed");
        this.explosionPower = compound.m_128457_("explosionScaling");
        this.maxVelocitySq = compound.m_128457_("topSpeedSq");
        this.entityFilter = EntityFilter.fromString(compound.m_128461_("filter"));
    }

    public void setTarget(Entity target) {
        this.targetEntity = target;
    }

    private class TargetSorter
    implements Comparator<Entity> {
        private final Vec3 vec;

        TargetSorter() {
            this.vec = MicromissileEntity.this.m_20182_();
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            return Double.compare(this.vec.m_82557_(e1.m_20182_()), this.vec.m_82557_(e2.m_20182_()));
        }
    }
}

