/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.ReinforcedChestBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ReinforcedChestMenu;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class ReinforcedChestBlockEntity
extends AbstractPneumaticCraftBlockEntity
implements MenuProvider,
IComparatorSupport {
    public static final int CHEST_SIZE = 36;
    public static final String NBT_ITEMS = "Items";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private static final String NBT_LOOT_TABLE_SEED = "LootTableSeed";
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private final ComparatorItemStackHandler inventory = new ComparatorItemStackHandler(this, 36){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.m_41720_() != ((ReinforcedChestBlock)ModBlocks.REINFORCED_CHEST.get()).m_5456_() && super.isItemValid(slot, stack);
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public ReinforcedChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REINFORCED_CHEST.get(), pos, state);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return this.inventoryCap;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.lootTable != null) {
            tag.m_128359_(NBT_LOOT_TABLE, this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                tag.m_128356_(NBT_LOOT_TABLE_SEED, this.lootTableSeed);
            }
        } else {
            tag.m_128365_(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(NBT_LOOT_TABLE, 8)) {
            this.lootTable = new ResourceLocation(tag.m_128461_(NBT_LOOT_TABLE));
            this.lootTableSeed = tag.m_128454_(NBT_LOOT_TABLE_SEED);
        } else {
            this.inventory.deserializeNBT(tag.m_128469_(NBT_ITEMS));
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            blockEntityTag.m_128365_(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
            break;
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        this.maybeFillWithLoot(player);
        return new ReinforcedChestMenu(windowId, inv, this.m_58899_());
    }

    public void maybeFillWithLoot(Player player) {
        Level level;
        if (this.lootTable != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable table = this.f_58857_.m_7654_().m_278653_().m_278676_(this.lootTable);
            this.lootTable = null;
            LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (player != null) {
                builder.m_287239_(player.m_36336_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            }
            RecipeWrapper invWrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
            table.m_287188_((Container)invWrapper, builder.m_287235_(LootContextParamSets.f_81411_), this.lootTableSeed);
            this.m_6596_();
        }
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getComparatorValue();
    }
}

