/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.entity.CachedTileNeighbours;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.ILuaMethodProvider;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.upgrades.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.upgrades.IUpgradeHolder;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.upgrades.UpgradeCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractPneumaticCraftBlockEntity
extends BlockEntity
implements Nameable,
IGUIButtonSensitive,
IDescSynced,
IUpgradeHolder,
ILuaMethodProvider {
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    private final UpgradeHandler upgradeHandler;
    private List<SyncedField<?>> descriptionFields;
    private final CachedTileNeighbours neighbourCache = new CachedTileNeighbours(this);
    private boolean preserveStateOnBreak = false;
    private float actualSpeedMult = 1.5f;
    private float actualUsageMult = 1.65f;
    private final LuaMethodRegistry luaMethodRegistry = new LuaMethodRegistry(this);
    private Component customName = null;
    private boolean forceFullSync;
    private BitSet fieldsToSync;

    public AbstractPneumaticCraftBlockEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        this(type, pos, state, 0);
    }

    public AbstractPneumaticCraftBlockEntity(BlockEntityType type, BlockPos pos, BlockState state, int upgradeSize) {
        super(type, pos, state);
        this.upgradeHandler = new UpgradeHandler(upgradeSize);
    }

    @Nonnull
    public Level nonNullLevel() {
        return Objects.requireNonNull(super.m_58904_());
    }

    private String getBlockTranslationKey() {
        return "block.pneumaticcraft." + ForgeRegistries.BLOCK_ENTITY_TYPES.getResourceKey((Object)this.m_58903_()).map(rk -> rk.m_135782_().m_135815_()).orElse("unknown");
    }

    public Component m_7755_() {
        return this.customName == null ? Component.m_237115_((String)this.getBlockTranslationKey()) : this.customName;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        return new PacketDescription(this, true).writeNBT(compound);
    }

    public void handleUpdateTag(CompoundTag tag) {
        new PacketDescription(tag).processPacket(this);
    }

    @Override
    public BlockPos getPosition() {
        return this.m_58899_();
    }

    @Override
    public boolean shouldSyncField(int idx) {
        return this.fieldsToSync.get(idx);
    }

    @Override
    public List<SyncedField<?>> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            this.fieldsToSync = new BitSet(this.descriptionFields.size());
            for (int i = 0; i < this.descriptionFields.size(); ++i) {
                SyncedField<?> field = this.descriptionFields.get(i);
                if (!field.update()) continue;
                this.fieldsToSync.set(i);
            }
        }
        return this.descriptionFields;
    }

    public final void sendDescriptionPacket() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        PacketDescription descPacket = new PacketDescription(this, this.forceFullSync);
        if (descPacket.hasData()) {
            NetworkHandler.sendToAllTracking((Object)descPacket, this);
        }
        this.fieldsToSync.clear();
        this.forceFullSync = false;
    }

    void scheduleDescriptionPacket() {
        this.forceFullSync = true;
    }

    void defaultServerTick() {
        if (!this.nonNullLevel().f_46443_) {
            IHeatExchangingTE he;
            IHeatExchangerLogic logic;
            AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
            if (abstractPneumaticCraftBlockEntity instanceof IHeatExchangingTE && (logic = (he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity)).getHeatExchanger()) != null) {
                logic.tick();
            }
            if ((abstractPneumaticCraftBlockEntity = this) instanceof IAutoFluidEjecting) {
                IAutoFluidEjecting ejector = (IAutoFluidEjecting)((Object)abstractPneumaticCraftBlockEntity);
                if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
                    ejector.autoExportFluid(this);
                }
            }
            for (int i = 0; i < this.getDescriptionFields().size(); ++i) {
                if (!this.getDescriptionFields().get(i).update()) continue;
                this.fieldsToSync.set(i);
            }
            if (this.forceFullSync || !this.fieldsToSync.isEmpty()) {
                this.sendDescriptionPacket();
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getInventoryCap(null).isPresent()) {
            this.getInventoryCap(null).invalidate();
        }
        if (this.getHeatCap(null).isPresent()) {
            this.getHeatCap(null).invalidate();
        }
        if (this.getFluidCap(null).isPresent()) {
            this.getFluidCap(null).invalidate();
        }
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_46749_(this.f_58858_)) {
                this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
            }
            if (this instanceof IComparatorSupport && !this.m_58900_().m_60795_()) {
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
    }

    public void onLoad() {
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
        if (abstractPneumaticCraftBlockEntity instanceof IHeatExchangingTE) {
            IHeatExchangingTE he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity);
            he.initializeHullHeatExchangers(this.f_58857_, this.f_58858_);
        }
    }

    protected void updateNeighbours() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        }
    }

    public void onBlockRotated() {
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
        if (abstractPneumaticCraftBlockEntity instanceof ISideConfigurable) {
            ISideConfigurable c = (ISideConfigurable)((Object)abstractPneumaticCraftBlockEntity);
            for (SideConfigurator sideConfigurator : c.getSideConfigurators()) {
                sideConfigurator.setupFacingMatrix();
            }
        }
        if (!this.nonNullLevel().f_46443_) {
            PneumaticRegistry.getInstance().getMiscHelpers().forceClientShapeRecalculation(this.f_58857_, this.f_58858_);
        }
    }

    void rerenderTileEntity() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    protected boolean shouldRerenderChunkOnDescUpdate() {
        return this instanceof CamouflageableBlockEntity;
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        if (this instanceof ISideConfigurable) {
            tag.m_128365_("SideConfiguration", (Tag)SideConfigurator.writeToNBT((ISideConfigurable)((Object)this)));
        }
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        if (this instanceof ISideConfigurable) {
            SideConfigurator.readFromNBT(tag.m_128469_("SideConfiguration"), (ISideConfigurable)((Object)this));
        }
    }

    public void m_183515_(CompoundTag tag) {
        IHeatExchangingTE he;
        IHeatExchangerLogic logic;
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity;
        super.m_183515_(tag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        if (this.getUpgradeHandler().getSlots() > 0) {
            tag.m_128365_("UpgradeInventory", (Tag)this.getUpgradeHandler().serializeNBT());
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IHeatExchangingTE && (logic = (he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity)).getHeatExchanger()) != null) {
            tag.m_128365_("HeatExchanger", (Tag)logic.serializeNBT());
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IRedstoneControl) {
            IRedstoneControl rc = (IRedstoneControl)((Object)abstractPneumaticCraftBlockEntity);
            rc.getRedstoneController().serialize(tag);
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof ISerializableTanks) {
            ISerializableTanks st = (ISerializableTanks)((Object)abstractPneumaticCraftBlockEntity);
            tag.m_128365_("SavedTanks", (Tag)st.serializeTanks());
        }
        this.writeToPacket(tag);
    }

    public void m_142466_(CompoundTag tag) {
        IHeatExchangingTE he;
        IHeatExchangerLogic logic;
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity;
        super.m_142466_(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        if (tag.m_128441_("UpgradeInventory") && this.getUpgradeHandler() != null) {
            this.getUpgradeHandler().deserializeNBT(tag.m_128469_("UpgradeInventory"));
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IHeatExchangingTE && (logic = (he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity)).getHeatExchanger()) != null) {
            logic.deserializeNBT(tag.m_128469_("HeatExchanger"));
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IRedstoneControl) {
            IRedstoneControl rc = (IRedstoneControl)((Object)abstractPneumaticCraftBlockEntity);
            rc.getRedstoneController().deserialize(tag);
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof ISerializableTanks) {
            ISerializableTanks st = (ISerializableTanks)((Object)abstractPneumaticCraftBlockEntity);
            st.deserializeTanks(tag.m_128469_("SavedTanks"));
        }
        this.readFromPacket(tag);
    }

    @Override
    public void onDescUpdate() {
        if (this.shouldRerenderChunkOnDescUpdate()) {
            this.rerenderTileEntity();
            if (this instanceof CamouflageableBlockEntity) {
                this.requestModelDataUpdate();
            }
        }
    }

    @Nonnull
    public ModelData getModelData() {
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
        if (abstractPneumaticCraftBlockEntity instanceof CamouflageableBlockEntity) {
            CamouflageableBlockEntity c = (CamouflageableBlockEntity)((Object)abstractPneumaticCraftBlockEntity);
            return ModelData.builder().with(AbstractCamouflageBlock.BLOCK_ACCESS, (Object)this.f_58857_).with(AbstractCamouflageBlock.BLOCK_POS, (Object)this.f_58858_).with(AbstractCamouflageBlock.CAMO_STATE, (Object)c.getCamouflage()).build();
        }
        return super.getModelData();
    }

    public void onGuiUpdate() {
    }

    public Direction getRotation() {
        Direction direction;
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof AbstractPneumaticCraftBlock) {
            AbstractPneumaticCraftBlock b = (AbstractPneumaticCraftBlock)block;
            direction = b.getRotation(state);
        } else {
            direction = Direction.NORTH;
        }
        return direction;
    }

    public int getUpgrades(PNCUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    public float getSpeedMultiplierFromUpgrades() {
        return this.actualSpeedMult;
    }

    public float getSpeedUsageMultiplierFromUpgrades() {
        return this.actualUsageMult;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
    }

    public boolean isGuiUseableByPlayer(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.m_58899_()) == this && player.m_20238_(Vec3.m_82512_((Vec3i)this.m_58899_())) <= 64.0;
    }

    public BlockEntity getCachedNeighbor(Direction dir) {
        if (this.f_58857_ == null) {
            return null;
        }
        return this.f_58857_.f_46443_ ? this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir)) : this.neighbourCache.getCachedNeighbour(dir);
    }

    public void onNeighborTileUpdate(BlockPos tilePos) {
    }

    public void onNeighborBlockUpdate(BlockPos fromPos) {
        AbstractPneumaticCraftBlockEntity abstractPneumaticCraftBlockEntity = this;
        if (abstractPneumaticCraftBlockEntity instanceof IHeatExchangingTE) {
            IHeatExchangingTE he = (IHeatExchangingTE)((Object)abstractPneumaticCraftBlockEntity);
            he.initializeHullHeatExchangers(this.f_58857_, this.f_58858_);
        }
        if ((abstractPneumaticCraftBlockEntity = this) instanceof IRedstoneControl) {
            IRedstoneControl rc = (IRedstoneControl)((Object)abstractPneumaticCraftBlockEntity);
            rc.getRedstoneController().updateRedstonePower();
        }
        this.neighbourCache.purge();
    }

    void processFluidItem(int inputSlot, int outputSlot) {
        this.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            ItemStack inputStack = itemHandler.getStackInSlot(inputSlot);
            ItemStack outputStack = itemHandler.getStackInSlot(outputSlot);
            if (inputStack.m_41613_() != 1) {
                return;
            }
            FluidUtil.getFluidHandler((ItemStack)inputStack).ifPresent(fluidHandlerItem -> {
                FluidStack itemContents = fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
                    FluidStack transferred;
                    if (!itemContents.isEmpty() && (outputStack.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)inputStack.m_41720_().getCraftingRemainingItem(inputStack), (ItemStack)outputStack))) {
                        FluidStack transferred2 = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)fluidHandlerItem, (int)itemContents.getAmount(), (boolean)true);
                        if (transferred2.getAmount() == itemContents.getAmount()) {
                            ItemStack emptyContainerStack = fluidHandlerItem.getContainer();
                            ItemStack excess = itemHandler.insertItem(outputSlot, emptyContainerStack, true);
                            if (excess.m_41619_()) {
                                itemHandler.extractItem(inputSlot, 1, false);
                                itemHandler.insertItem(outputSlot, emptyContainerStack, false);
                            }
                        } else if (!transferred2.isEmpty()) {
                            itemHandler.extractItem(inputSlot, 1, false);
                            itemHandler.insertItem(inputSlot, fluidHandlerItem.getContainer().m_41777_(), false);
                        }
                    } else if (itemHandler.getStackInSlot(outputSlot).m_41619_() && !(transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true)).isEmpty()) {
                        itemHandler.extractItem(inputSlot, 1, false);
                        ItemStack filledContainerStack = fluidHandlerItem.getContainer();
                        itemHandler.insertItem(outputSlot, filledContainerStack, false);
                    }
                });
            });
        });
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        if (this instanceof IHeatExchangingTE) {
            registry.registerLuaMethod(new LuaMethod("getTemperature"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireArgs(args, 0, 1, "face? (down/up/north/south/west/east)");
                    Direction dir = args.length == 0 ? null : this.getDirForString((String)args[0]);
                    IHeatExchangerLogic logic = ((IHeatExchangingTE)((Object)AbstractPneumaticCraftBlockEntity.this)).getHeatExchanger(dir);
                    double temp = logic == null ? HeatExchangerLogicAmbient.getAmbientTemperature((LevelAccessor)AbstractPneumaticCraftBlockEntity.this.f_58857_, AbstractPneumaticCraftBlockEntity.this.f_58858_) : logic.getTemperature();
                    return new Object[]{temp};
                }
            });
        }
    }

    @Override
    public LuaMethodRegistry getLuaMethodRegistry() {
        return this.luaMethodRegistry;
    }

    @Override
    public String getPeripheralType() {
        return ForgeRegistries.BLOCK_ENTITY_TYPES.getResourceKey((Object)this.m_58903_()).map(rk -> rk.m_135782_().toString()).orElse("unknown");
    }

    public abstract IItemHandler getPrimaryInventory();

    public UpgradeHandler getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getInventoryCap(side).cast();
        }
        if (cap == PNCCapabilities.HEAT_EXCHANGER_CAPABILITY) {
            return this.getHeatCap(side).cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.getFluidCap(side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergyCap(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    protected LazyOptional<IEnergyStorage> getEnergyCap(Direction side) {
        return LazyOptional.empty();
    }

    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap(Direction side) {
        return LazyOptional.empty();
    }

    @Nonnull
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return LazyOptional.empty();
    }

    @Nonnull
    public LazyOptional<IFluidHandler> getFluidCap(Direction side) {
        return LazyOptional.empty();
    }

    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        CamouflageableBlockEntity c;
        BlockState camoState;
        AbstractPneumaticCraftBlockEntity i2;
        PneumaticCraftUtils.collectNonEmptyItems(this.getPrimaryInventory(), drops);
        if (!this.shouldPreserveStateOnBreak()) {
            UpgradeHandler uh = this.getUpgradeHandler();
            for (int i2 = 0; i2 < uh.getSlots(); ++i2) {
                if (uh.getStackInSlot(i2).m_41619_()) continue;
                drops.add((Object)uh.getStackInSlot(i2));
            }
        }
        if ((i2 = this) instanceof CamouflageableBlockEntity && (camoState = (c = (CamouflageableBlockEntity)((Object)i2)).getCamouflage()) != null) {
            drops.add((Object)CamouflageableBlockEntity.getStackForState(camoState));
        }
    }

    public boolean shouldPreserveStateOnBreak() {
        return this.preserveStateOnBreak;
    }

    public void setPreserveStateOnBreak(boolean preserveStateOnBreak) {
        this.preserveStateOnBreak = preserveStateOnBreak;
    }

    public String getCurrentRecipeIdSynced() {
        return "";
    }

    @Override
    public void onUpgradesChanged() {
        this.actualSpeedMult = (float)Math.pow((Double)ConfigHelper.common().machines.speedUpgradeSpeedMultiplier.get(), Math.min(10, this.getUpgrades(ModUpgrades.SPEED.get())));
        this.actualUsageMult = (float)Math.pow((Double)ConfigHelper.common().machines.speedUpgradeUsageMultiplier.get(), Math.min(10, this.getUpgrades(ModUpgrades.SPEED.get())));
    }

    public UpgradeCache getUpgradeCache() {
        return this.upgradeCache;
    }

    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
    }

    public int countPlayersUsing() {
        return (int)this.nonNullLevel().m_6907_().stream().filter(player -> player.f_36096_ instanceof AbstractPneumaticCraftMenu).filter(player -> ((AbstractPneumaticCraftMenu)player.f_36096_).te == this).count();
    }

    public void requestModelDataUpdate() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.f_58857_ == ClientUtils.getClientLevel()) {
            this.f_58857_.getModelDataManager().requestRefresh((BlockEntity)this);
        }
    }

    public class UpgradeHandler
    extends BaseItemStackHandler {
        UpgradeHandler(int upgradeSize) {
            super(AbstractPneumaticCraftBlockEntity.this, upgradeSize);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.m_41619_() || this.isApplicable(itemStack) && this.isUnique(slot, itemStack);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            PNCUpgrade upgrade = PNCUpgrade.from(stack);
            if (upgrade == null) {
                return 0;
            }
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.te, upgrade);
        }

        private boolean isUnique(int slot, ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i == slot || PNCUpgrade.from(stack) != PNCUpgrade.from(this.getStackInSlot(i))) continue;
                return false;
            }
            return true;
        }

        private boolean isApplicable(ItemStack stack) {
            PNCUpgrade upgrade = PNCUpgrade.from(stack);
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(AbstractPneumaticCraftBlockEntity.this, upgrade) > 0;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AbstractPneumaticCraftBlockEntity.this.upgradeCache.invalidateCache();
        }
    }
}

