/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketSendDimletPackages {
    private final Map<DimletKey, DimletSettings> dimlets;

    public PacketSendDimletPackages(Map<DimletKey, DimletSettings> dimlets) {
        this.dimlets = new HashMap<DimletKey, DimletSettings>(dimlets);
    }

    public PacketSendDimletPackages(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.dimlets = new HashMap<DimletKey, DimletSettings>(size);
        for (int i = 0; i < size; ++i) {
            DimletKey key = DimletKey.create(buf);
            DimletSettings settings = new DimletSettings(buf);
            this.dimlets.put(key, settings);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.dimlets.size());
        for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
            entry.getKey().toBytes(buf);
            entry.getValue().toBytes(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            RegistryAccess access = SafeClientTools.getClientWorld().m_9598_();
            DimletDictionary dictionary = DimletDictionary.get();
            for (Map.Entry<DimletKey, DimletSettings> entry : this.dimlets.entrySet()) {
                dictionary.register(access, entry.getKey(), entry.getValue());
            }
        });
        ctx.setPacketHandled(true);
    }
}

