/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.mixin.client.roll.entity;

import net.minecraft.client.player.LocalPlayer;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.flight.RotationModifiers;
import nl.enjarai.doabarrelroll.mixin.client.roll.entity.AbstractClientPlayerEntityMixin;
import nl.enjarai.doabarrelroll.net.register.RollSyncClient;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends AbstractClientPlayerEntityMixin {
    @Shadow
    public float f_108585_;
    @Shadow
    public float f_108587_;
    @Unique
    private boolean lastSentIsRolling;
    @Unique
    private float lastSentRoll;

    @Inject(method={"sendMovementPackets"}, at={@At(value="TAIL")})
    private void doABarrelRoll$sendRollPacket(CallbackInfo ci) {
        boolean isRolling = this.doABarrelRoll$isRolling();
        float rollDiff = this.doABarrelRoll$getRoll() - this.lastSentRoll;
        if (isRolling != this.lastSentIsRolling || rollDiff != 0.0f) {
            RollSyncClient.sendUpdate(this);
            this.lastSentIsRolling = isRolling;
            this.lastSentRoll = this.doABarrelRoll$getRoll();
        }
    }

    @Override
    protected void doABarrelRoll$baseTickTail(CallbackInfo ci) {
        this.doABarrelRoll$setRolling(RollEvents.shouldRoll());
        super.doABarrelRoll$baseTickTail(ci);
    }

    @Override
    public void doABarrelRoll$changeElytraLook(double pitch, double yaw, double roll, Sensitivity sensitivity, double mouseDelta) {
        RotationInstant rotDelta = RotationInstant.of(pitch, yaw, roll);
        float currentRoll = this.doABarrelRoll$getRoll();
        RotationInstant currentRotation = RotationInstant.of(this.m_146909_(), this.m_146908_(), currentRoll);
        RollContext context = RollContext.of(currentRotation, rotDelta, mouseDelta);
        context.useModifier(RotationModifiers.fixNaN("INPUT"));
        RollEvents.earlyCameraModifiers(context);
        context.useModifier(RotationModifiers.fixNaN("EARLY_CAMERA_MODIFIERS"));
        context.useModifier((rotation, ctx) -> rotation.applySensitivity(sensitivity));
        context.useModifier(RotationModifiers.fixNaN("SENSITIVITY"));
        RollEvents.lateCameraModifiers(context);
        context.useModifier(RotationModifiers.fixNaN("LATE_CAMERA_MODIFIERS"));
        rotDelta = context.getRotationDelta();
        this.doABarrelRoll$changeElytraLook((float)rotDelta.pitch(), (float)rotDelta.yaw(), (float)rotDelta.roll());
    }

    @Override
    public void doABarrelRoll$changeElytraLook(float pitch, float yaw, float roll) {
        float currentPitch = this.m_146909_();
        float currentYaw = this.m_146908_();
        float currentRoll = this.doABarrelRoll$getRoll();
        Vector3d facing = new Vector3d((Vector3fc)this.m_20156_().m_252839_());
        Vector3d left = new Vector3d(1.0, 0.0, 0.0);
        left.rotateZ((double)(-currentRoll) * (Math.PI / 180));
        left.rotateX((double)(-currentPitch) * (Math.PI / 180));
        left.rotateY((double)(-(currentYaw + 180.0f)) * (Math.PI / 180));
        facing.rotateAxis(-0.15 * (double)pitch * (Math.PI / 180), left.x, left.y, left.z);
        Vector3d up = facing.cross((Vector3dc)left, new Vector3d());
        facing.rotateAxis(0.15 * (double)yaw * (Math.PI / 180), up.x, up.y, up.z);
        left.rotateAxis(0.15 * (double)yaw * (Math.PI / 180), up.x, up.y, up.z);
        left.rotateAxis(0.15 * (double)roll * (Math.PI / 180), facing.x, facing.y, facing.z);
        double newPitch = -Math.asin(facing.y) * 57.29577951308232;
        double newYaw = -Math.atan2(facing.x, facing.z) * 57.29577951308232;
        Vector3d normalLeft = new Vector3d(1.0, 0.0, 0.0).rotateY(-(newYaw + 180.0) * (Math.PI / 180));
        double newRoll = -Math.atan2(left.cross((Vector3dc)normalLeft, new Vector3d()).dot((Vector3dc)facing), left.dot((Vector3dc)normalLeft)) * 57.29577951308232;
        double deltaY = newPitch - (double)currentPitch;
        double deltaX = newYaw - (double)currentYaw;
        double deltaRoll = newRoll - (double)currentRoll;
        this.m_19884_(deltaX / 0.15, deltaY / 0.15);
        this.roll += (float)deltaRoll;
        this.prevRoll += (float)deltaRoll;
        if (this.m_146908_() < -90.0f && this.f_108585_ > 90.0f) {
            this.f_108585_ -= 360.0f;
            this.f_108587_ -= 360.0f;
        } else if (this.m_146908_() > 90.0f && this.f_108585_ < -90.0f) {
            this.f_108585_ += 360.0f;
            this.f_108587_ += 360.0f;
        }
    }
}

