/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.shadow.codechicken.lib.model.pipeline.transformers;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;
import org.zeith.multipart.microblocks.shadow.fabric.MutableQuadView;
import org.zeith.multipart.microblocks.shadow.fabric.RenderContext;

public class QuadClamper
implements RenderContext.QuadTransform {
    private final AABB clampBounds;
    private final Vector3f pos = new Vector3f();

    public QuadClamper(AABB clampBounds) {
        this.clampBounds = clampBounds;
    }

    @Override
    public boolean transform(MutableQuadView quad) {
        int s = quad.nominalFace().ordinal() >> 1;
        this.clamp(quad, this.clampBounds);
        float x1 = quad.posByIndex(0, QuadClamper.dx(s));
        float x2 = quad.posByIndex(1, QuadClamper.dx(s));
        float x3 = quad.posByIndex(2, QuadClamper.dx(s));
        float x4 = quad.posByIndex(3, QuadClamper.dx(s));
        float y1 = quad.posByIndex(0, QuadClamper.dy(s));
        float y2 = quad.posByIndex(1, QuadClamper.dy(s));
        float y3 = quad.posByIndex(2, QuadClamper.dy(s));
        float y4 = quad.posByIndex(3, QuadClamper.dy(s));
        boolean flag1 = x1 == x2 && x2 == x3 && x3 == x4;
        boolean flag2 = y1 == y2 && y2 == y3 && y3 == y4;
        return !flag1 && !flag2;
    }

    private void clamp(MutableQuadView quad, AABB bb) {
        for (int i = 0; i < 4; ++i) {
            quad.copyPos(i, this.pos);
            this.pos.set((float)Mth.m_14008_((double)this.pos.x(), (double)bb.f_82288_, (double)bb.f_82291_), (float)Mth.m_14008_((double)this.pos.y(), (double)bb.f_82289_, (double)bb.f_82292_), (float)Mth.m_14008_((double)this.pos.z(), (double)bb.f_82290_, (double)bb.f_82293_));
            quad.pos(i, this.pos);
        }
    }

    private static int dx(int s) {
        if (s <= 1) {
            return 0;
        }
        return 2;
    }

    private static int dy(int s) {
        if (s > 0) {
            return 1;
        }
        return 2;
    }
}

