/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.multipart;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.IConfiguredPartPlacer;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.client.IClientPartDefinitionExtensions;
import org.zeith.multipart.client.MultipartEffects;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.tile.MicroblockState;
import org.zeith.multipart.microblocks.client.resource.model.ModelGeneratorSystem;
import org.zeith.multipart.microblocks.contents.multipart.entity.MicroblockEntity;
import org.zeith.multipart.microblocks.init.PartDefinitionsHM;

public class MicroblockPartDefinition
extends PartDefinition {
    public boolean canPlaceAt(PartContainer container, @Nullable IConfiguredPartPlacer placer, PartPlacement placement) {
        return super.canPlaceAt(container, placer, placement);
    }

    public SoundType getSoundType(PartEntity entity) {
        SoundType soundType;
        if (entity instanceof MicroblockEntity) {
            MicroblockEntity mb = (MicroblockEntity)entity;
            soundType = mb.getSoundType();
        } else {
            soundType = SoundType.f_56742_;
        }
        return soundType;
    }

    public MicroblockEntity createEntity(PartContainer container, PartPlacement placement) {
        return new MicroblockEntity(this, container, placement);
    }

    public void initializeClient(Consumer<IClientPartDefinitionExtensions> consumer) {
        consumer.accept(new IClientPartDefinitionExtensions(){

            private MultipartEffects.TintedSprite getSpriteFor(PartEntity part) {
                MicroblockEntity mb;
                block3: {
                    block2: {
                        if (!(part instanceof MicroblockEntity)) break block2;
                        mb = (MicroblockEntity)part;
                        if (mb.state.isValid()) break block3;
                    }
                    return null;
                }
                Minecraft mc = Minecraft.m_91087_();
                BakedModel model = mc.m_91289_().m_110910_(mb.state.asBlockState());
                return new MultipartEffects.TintedSprite(model.getParticleIcon(ModelData.EMPTY));
            }

            public boolean addHitEffects(BlockHitResult target, PartEntity part, ParticleEngine manager) {
                MultipartEffects.spawnHitFX((VoxelShape)part.getShape(), (BlockHitResult)target, () -> this.getSpriteFor(part));
                return true;
            }

            public boolean addDestroyEffects(PartEntity part, ParticleEngine manager) {
                MultipartEffects.spawnBreakFX((BlockPos)part.container().pos(), (VoxelShape)part.getShape(), () -> this.getSpriteFor(part));
                return true;
            }

            public void addRunningEffects(PartEntity part, VoxelShape shape, Entity living, AABB entityBb, Vec3 particlePos, Vec3 particleMotion) {
                MultipartEffects.spawnRunningFX((BlockPos)part.container().pos(), (VoxelShape)shape, (Vec3)particlePos, (Vec3)particleMotion, () -> this.getSpriteFor(part));
            }

            public void addLandingEffects(PartEntity part, VoxelShape shape, LivingEntity living, int numberOfParticles, AABB entityBb, Vec3 particlePos) {
                MultipartEffects.spawnLandingFX((BlockPos)part.container().pos(), (VoxelShape)shape, (Vec3)particlePos, (int)numberOfParticles, () -> this.getSpriteFor(part));
            }

            public boolean getQuads(PartEntity part, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType, Consumer<BakedQuad> addQuad) {
                if (!(part instanceof MicroblockEntity)) {
                    return true;
                }
                MicroblockEntity mb = (MicroblockEntity)part;
                if (side != null) {
                    return true;
                }
                PartContainer ctr = part.container();
                MicroblockState state = mb.state;
                if (!state.isValid()) {
                    return true;
                }
                RandomSource rng = RandomSource.m_216335_((long)ctr.pos().m_121878_());
                PartPlacement placement = mb.placement();
                MicroblockData extraData = mb.state.getData();
                List<AABB> strips = state.getType().getModelStrips(placement, extraData);
                ModelGeneratorSystem.generateMesh(state.getType(), placement, extraData, ctr, (BlockAndTintGetter)ctr.level(), ctr.pos(), strips, state.asBlockState(), rng, renderType).toBakedBlockQuads().forEach(addQuad);
                return true;
            }
        });
    }

    public record MicroblockConfiguration(MicroblockState state) implements IConfiguredPartPlacer
    {
        public PartEntity create(PartContainer container, PartPlacement placement) {
            if (!this.state.isValid()) {
                return null;
            }
            MicroblockEntity e = new MicroblockEntity(PartDefinitionsHM.MICROBLOCK, container, placement);
            e.initState(this.state);
            return e;
        }
    }
}

