/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.microblocks;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;
import org.zeith.multipart.microblocks.api.grids.PlanarPlacementGrid;
import org.zeith.multipart.microblocks.contents.multipart.entity.MicroblockEntity;

public class PlanarMicroblockType
extends MicroblockType {
    protected final List<List<AABB>> boxes;
    protected final List<VoxelShape> shapes;
    public final double thickness;
    public boolean compatibleWithSameTypeEdged;

    public PlanarMicroblockType(float thickness, boolean compatibleWithSameTypeEdged) {
        this.thickness = (double)thickness / 16.0;
        this.compatibleWithSameTypeEdged = compatibleWithSameTypeEdged;
        this.boxes = this.createAABBs();
        this.shapes = this.createShapes();
    }

    protected List<VoxelShape> createShapes() {
        return List.of(Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.thickness, (double)1.0), Shapes.m_83048_((double)0.0, (double)(1.0 - this.thickness), (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)this.thickness), Shapes.m_83048_((double)0.0, (double)0.0, (double)(1.0 - this.thickness), (double)1.0, (double)1.0, (double)1.0), Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)this.thickness, (double)1.0, (double)1.0), Shapes.m_83048_((double)(1.0 - this.thickness), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
    }

    protected List<List<AABB>> createAABBs() {
        return this.createShapes().stream().map(VoxelShape::m_83299_).toList();
    }

    @Override
    public MicroblockPlacementGrid getPlacementGrid() {
        return PlanarPlacementGrid.INSTANCE;
    }

    @Override
    public VoxelShape getOccupationShapeFor(PartPlacement ourPlacement, MicroblockType futureType, PartPlacement futureTypePlacement, MicroblockEntity futureEntity, @Nullable MicroblockData data) {
        if (futureType instanceof PlanarMicroblockType) {
            PlanarMicroblockType other = (PlanarMicroblockType)futureType;
            if (other.thickness == this.thickness && this.compatibleWithSameTypeEdged) {
                return Shapes.m_83040_();
            }
        }
        return super.getOccupationShapeFor(ourPlacement, futureType, futureTypePlacement, futureEntity, data);
    }

    @Override
    public List<AABB> getModelStrips(PartPlacement placement, @Nullable MicroblockData data) {
        Direction dir = placement.getDirection();
        if (dir == null) {
            return List.of();
        }
        return this.boxes.get(dir.ordinal());
    }

    @Override
    public VoxelShape getShape(PartPlacement placement, @Nullable MicroblockData data) {
        Direction dir = placement.getDirection();
        if (dir == null) {
            return Shapes.m_83040_();
        }
        return this.shapes.get(dir.ordinal());
    }
}

