/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.microblocks;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.microblocks.api.MicroblockData;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.data.IAxialMicroblockData;
import org.zeith.multipart.microblocks.api.grids.MicroblockPlacementGrid;
import org.zeith.multipart.microblocks.api.grids.PlanarPillarPlacementGrid;

public class PillarMicroblockType
extends MicroblockType {
    public final double thickness;
    protected final List<List<AABB>> boxes;
    protected final List<VoxelShape> shapes;

    public PillarMicroblockType(float thickness) {
        this.thickness = (double)thickness / 32.0;
        this.boxes = this.createAABBs();
        this.shapes = this.createShapes();
    }

    protected List<VoxelShape> createShapes() {
        return List.of(Shapes.m_83048_((double)0.0, (double)(0.5 - this.thickness), (double)(0.5 - this.thickness), (double)1.0, (double)(0.5 + this.thickness), (double)(0.5 + this.thickness)), Shapes.m_83048_((double)(0.5 - this.thickness), (double)0.0, (double)(0.5 - this.thickness), (double)(0.5 + this.thickness), (double)1.0, (double)(0.5 + this.thickness)), Shapes.m_83048_((double)(0.5 - this.thickness), (double)(0.5 - this.thickness), (double)0.0, (double)(0.5 + this.thickness), (double)(0.5 + this.thickness), (double)1.0));
    }

    protected List<List<AABB>> createAABBs() {
        return this.createShapes().stream().map(VoxelShape::m_83299_).toList();
    }

    @Override
    public MicroblockPlacementGrid getPlacementGrid() {
        return PlanarPillarPlacementGrid.INSTANCE;
    }

    @Override
    public List<AABB> getModelStrips(PartPlacement placement, @Nullable MicroblockData data) {
        if (data instanceof IAxialMicroblockData) {
            IAxialMicroblockData ax = (IAxialMicroblockData)((Object)data);
            return this.boxes.get(ax.getAxis().ordinal());
        }
        return this.boxes.get(1);
    }

    @Override
    public VoxelShape getShape(PartPlacement placement, @Nullable MicroblockData data) {
        if (data instanceof IAxialMicroblockData) {
            IAxialMicroblockData ax = (IAxialMicroblockData)((Object)data);
            return this.shapes.get(ax.getAxis().ordinal());
        }
        return this.shapes.get(1);
    }

    @Override
    public MicroblockData createDataForPlacement(Player player, BlockHitResult hit, boolean sameBlock) {
        return this.createEmptyData().withAxis(hit.m_82434_().m_122434_());
    }

    @Override
    @Nullable
    public MicroblockData createItemData() {
        return this.createEmptyData().withAxis(Direction.Axis.Y);
    }

    @Override
    @NotNull
    public PillarMicroblockData createEmptyData() {
        return new PillarMicroblockData();
    }

    public static class PillarMicroblockData
    extends MicroblockData
    implements IAxialMicroblockData {
        @NBTSerializable(value="Axis")
        public Direction.Axis axis = Direction.Axis.Y;

        public PillarMicroblockData withAxis(Direction.Axis axis) {
            this.axis = axis;
            return this;
        }

        @Override
        public Direction.Axis getAxis() {
            return this.axis;
        }
    }
}

