/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.contents.items;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.TierSortingRegistry;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.core.adapter.TagAdapter;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.multipart.microblocks.HammerMicroblocks;
import org.zeith.multipart.microblocks.init.TagsHM;

public class ItemSaw
extends DiggerItem
implements IRegisterListener {
    private static final Set<ItemSaw> SAW_ITEMS = Collections.synchronizedSet(new LinkedHashSet());
    protected final float tierIndex;

    public ItemSaw(float tierIndex, Tier tier, float baseDamage, float speedModifier, Item.Properties properties) {
        super(baseDamage, speedModifier, tier, TagsHM.Blocks.MINEABLE_WITH_SAW, properties);
        this.tierIndex = tierIndex;
        HLConstants.HL_TAB.add((ItemLike)this);
        HammerMicroblocks.MICROBLOCKS_TAB.add((ItemLike)this);
        TagAdapter.bind(TagsHM.Items.TOOLS_SAW, (Object[])new Item[]{this});
    }

    public final void onPostRegistered() {
        SAW_ITEMS.add(this);
        this.onPostRegisteredHook();
    }

    protected void onPostRegisteredHook() {
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack stack = itemStack.m_41777_();
        int md = itemStack.m_41776_();
        if (md > 0) {
            int dv = stack.m_41773_();
            if (dv < md) {
                stack.m_41721_(dv + 1);
            } else {
                return ItemStack.f_41583_;
            }
        }
        return stack;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public static Ingredient getSawsMatchingTier(Tier tier) {
        List sorted = TierSortingRegistry.getSortedTiers();
        int idx = sorted.indexOf(tier);
        if (idx == -1) {
            return Ingredient.m_43929_((ItemLike[])((ItemLike[])SAW_ITEMS.toArray(ItemSaw[]::new)));
        }
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])SAW_ITEMS.stream().filter(saw -> sorted.indexOf(saw.m_43314_()) >= idx).toArray(ItemSaw[]::new)));
    }

    public static Ingredient getSawsMatchingTier(float tier) {
        return Ingredient.m_43929_((ItemLike[])((ItemLike[])SAW_ITEMS.stream().filter(saw -> saw.tierIndex >= tier).toArray(ItemSaw[]::new)));
    }

    public static Stream<ItemSaw> all() {
        return SAW_ITEMS.stream();
    }
}

