/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.microblocks.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.zeith.multipart.microblocks.HammerMicroblocks;
import org.zeith.multipart.microblocks.api.MicroblockType;
import org.zeith.multipart.microblocks.api.recipe.MicroblockIngredient;
import org.zeith.multipart.microblocks.api.recipe.combination.IMicroblockComboRecipe;
import org.zeith.multipart.microblocks.api.recipe.combination.ShapedMicroblockRecipe;
import org.zeith.multipart.microblocks.api.recipe.combination.ShapelessMicroblockRecipe;
import org.zeith.multipart.microblocks.compat.jei.JEIHammerMicroblocks;
import org.zeith.multipart.microblocks.init.ItemsHM;
import org.zeith.multipart.microblocks.init.MicroblockTypesHM;

public class MicroblockCombinationCategory
implements IRecipeCategory<IMicroblockComboRecipe> {
    protected final IGuiHelper helper;
    protected final IDrawable background;
    protected final IDrawable icon;
    protected final Component title;

    public MicroblockCombinationCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(new ResourceLocation("textures/gui/container/crafting_table.png"), 29, 16, 116, 54);
        this.icon = helper.createDrawableItemStack(ItemsHM.MICROBLOCK.forItemRaw(MicroblockTypesHM.HOLLOW_COVER, Items.f_41905_.m_7968_(), 1));
        this.title = Component.m_237115_((String)"jei.hammermicroblocks.microblock_combination");
    }

    public RecipeType<IMicroblockComboRecipe> getRecipeType() {
        return JEIHammerMicroblocks.COMBINATION_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IMicroblockComboRecipe recipe, IFocusGroup focuses) {
        NonNullList<MicroblockIngredient> inputsRaw;
        ICraftingGridHelper gridHelper = this.helper.createCraftingGridHelper();
        ItemStack materials = Items.f_41905_.m_7968_();
        int width = 0;
        int height = 0;
        ArrayList inputs = new ArrayList();
        if (recipe instanceof ShapedMicroblockRecipe) {
            ShapedMicroblockRecipe r = (ShapedMicroblockRecipe)recipe;
            width = r.width();
            height = r.height();
            inputsRaw = r.inputs();
        } else if (recipe instanceof ShapelessMicroblockRecipe) {
            ShapelessMicroblockRecipe r = (ShapelessMicroblockRecipe)recipe;
            inputsRaw = r.inputs();
        } else {
            return;
        }
        for (MicroblockIngredient obj : inputsRaw) {
            ArrayList<ItemStack> itemsHere = new ArrayList<ItemStack>();
            if (obj.isFullBlock()) {
                itemsHere.add(materials.m_255036_(1));
            } else {
                HammerMicroblocks.microblockTypes().getValues().stream().filter(obj::matchesType).map(t -> ItemsHM.MICROBLOCK.forItemRaw((MicroblockType)t, materials, 1)).forEach(itemsHere::add);
            }
            inputs.add(itemsHere);
        }
        IMicroblockComboRecipe.FusionRecipeResult result = recipe.getBaseResult();
        ItemStack resItem = result.outputIsFullBlock() ? materials : ItemsHM.MICROBLOCK.forItemRaw(result.type(), materials, result.count());
        gridHelper.createAndSetOutputs(builder, List.of(resItem));
        gridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    public boolean isHandled(IMicroblockComboRecipe recipe) {
        return recipe instanceof ShapedMicroblockRecipe || recipe instanceof ShapelessMicroblockRecipe;
    }
}

